/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.k;
import com.google.android.gms.fitness.service.SensorEventDispatcher;
import com.google.android.gms.fitness.service.a;
import com.google.android.gms.fitness.service.b;
import java.util.concurrent.TimeUnit;

public class FitnessSensorServiceRequest
implements SafeParcelable {
    public static final int UNSPECIFIED = -1;
    private final int nZ;
    private final DataSource rc;
    private final k tp;
    private final long tS;
    private final long tT;
    public static final Parcelable.Creator<FitnessSensorServiceRequest> CREATOR = new a();

    FitnessSensorServiceRequest(int versionCode, DataSource dataSource, IBinder listenerBinder, long samplingRateMicros, long batchIntervalMicros) {
        this.nZ = versionCode;
        this.rc = dataSource;
        this.tp = k.a.l(listenerBinder);
        this.tS = samplingRateMicros;
        this.tT = batchIntervalMicros;
    }

    public DataSource getDataSource() {
        return this.rc;
    }

    public SensorEventDispatcher getDispatcher() {
        return new b(this.tp);
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return this.tS == -1L ? -1L : timeUnit.convert(this.tS, TimeUnit.MICROSECONDS);
    }

    public long getBatchInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.tT, TimeUnit.MICROSECONDS);
    }

    public String toString() {
        return String.format("FitnessSensorServiceRequest{%s}", this.rc);
    }

    int getVersionCode() {
        return this.nZ;
    }

    IBinder cZ() {
        return this.tp.asBinder();
    }

    public long cA() {
        return this.tS;
    }

    public long dq() {
        return this.tT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        a.a(this, parcel, flags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FitnessSensorServiceRequest && this.a((FitnessSensorServiceRequest)that);
    }

    private boolean a(FitnessSensorServiceRequest fitnessSensorServiceRequest) {
        return l.equal(this.rc, fitnessSensorServiceRequest.rc) && this.tS == fitnessSensorServiceRequest.tS && this.tT == fitnessSensorServiceRequest.tT;
    }

    public int hashCode() {
        return l.hashCode(this.rc, this.tS, this.tT);
    }
}

