/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.t;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int nZ;
    private final String tC;
    private final String tD;
    private final long pl;
    private final long rd;
    private final List<DataType> ro;
    private final List<DataSource> sZ;
    private boolean tE;
    private final boolean tk;
    private final List<String> tF;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new t();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages) {
        this.nZ = versionCode;
        this.tC = sessionName;
        this.tD = sessionId;
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.ro = Collections.unmodifiableList(dataTypes);
        this.sZ = Collections.unmodifiableList(dataSources);
        this.tE = getSessionsFromAllApps;
        this.tk = serverQueriesEnabled;
        this.tF = excludedPackages;
    }

    private SessionReadRequest(Builder builder) {
        this.nZ = 3;
        this.tC = builder.tC;
        this.tD = builder.tD;
        this.pl = builder.pl;
        this.rd = builder.rd;
        this.ro = Collections.unmodifiableList(builder.ro);
        this.sZ = Collections.unmodifiableList(builder.sZ);
        this.tE = builder.tE;
        this.tk = builder.tk;
        this.tF = Collections.unmodifiableList(builder.tF);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.pl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rd, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.tC;
    }

    public String getSessionId() {
        return this.tD;
    }

    public List<DataType> getDataTypes() {
        return this.ro;
    }

    public List<DataSource> getDataSources() {
        return this.sZ;
    }

    public boolean includeSessionsFromAllApps() {
        return this.tE;
    }

    public List<String> getExcludedPackages() {
        return this.tF;
    }

    public boolean cO() {
        return this.tk;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof SessionReadRequest && this.a((SessionReadRequest)o2);
    }

    private boolean a(SessionReadRequest sessionReadRequest) {
        return l.equal(this.tC, sessionReadRequest.tC) && this.tD.equals(sessionReadRequest.tD) && this.pl == sessionReadRequest.pl && this.rd == sessionReadRequest.rd && l.equal(this.ro, sessionReadRequest.ro) && l.equal(this.sZ, sessionReadRequest.sZ) && this.tE == sessionReadRequest.tE && this.tF.equals(sessionReadRequest.tF) && this.tk == sessionReadRequest.tk;
    }

    public int hashCode() {
        return l.hashCode(this.tC, this.tD, this.pl, this.rd);
    }

    public String toString() {
        return l.e(this).a("sessionName", this.tC).a("sessionId", this.tD).a("startTimeMillis", this.pl).a("endTimeMillis", this.rd).a("dataTypes", this.ro).a("dataSources", this.sZ).a("sessionsFromAllApps", this.tE).a("excludedPackages", this.tF).a("useServer", this.tk).toString();
    }

    public long ch() {
        return this.rd;
    }

    public long cg() {
        return this.pl;
    }

    public boolean dc() {
        return this.tE;
    }

    int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        t.a(this, dest, flags);
    }

    public static class Builder {
        private String tC;
        private String tD;
        private long pl = 0L;
        private long rd = 0L;
        private List<DataType> ro = new ArrayList<DataType>();
        private List<DataSource> sZ = new ArrayList<DataSource>();
        private boolean tE = false;
        private boolean tk = false;
        private List<String> tF = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.pl = timeUnit.toMillis(startTime);
            this.rd = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.tC = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.tD = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            m.a(dataSource, (Object)"Attempting to add a null data source");
            if (!this.sZ.contains(dataSource)) {
                this.sZ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            m.a(dataType, (Object)"Attempting to use a null data type");
            if (!this.ro.contains(dataType)) {
                this.ro.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.tE = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            m.a(appPackageName, (Object)"Attempting to use a null package name");
            if (!this.tF.contains(appPackageName)) {
                this.tF.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.tk = true;
            return this;
        }

        public SessionReadRequest build() {
            m.b(this.pl > 0L, "Invalid start time: %s", this.pl);
            m.b(this.rd > 0L && this.rd > this.pl, "Invalid end time: %s", this.rd);
            return new SessionReadRequest(this);
        }
    }
}

