/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource rc;
    private final DataType rb;
    private final long sh;
    private final long tt;
    private final long ts;
    private final int si;
    private final LocationRequest tx;
    private final long ty;

    private SensorRequest(Builder builder) {
        this.rc = builder.rc;
        this.rb = builder.rb;
        this.sh = builder.sh;
        this.tt = builder.tt;
        this.ts = builder.ts;
        this.si = builder.si;
        this.tx = null;
        this.ty = builder.ty;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.tx = locationRequest;
        this.sh = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.tt = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.ts = this.sh;
        this.rb = dataSource.getDataType();
        this.si = SensorRequest.a(locationRequest);
        this.rc = dataSource;
        long l2 = locationRequest.getExpirationTime();
        this.ty = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l2 - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int a(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.rc;
    }

    public DataType getDataType() {
        return this.rb;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.sh, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.tt, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.ts, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.si;
    }

    public long da() {
        return this.ty;
    }

    public String toString() {
        return l.e(this).a("dataSource", this.rc).a("dataType", this.rb).a("samplingRateMicros", this.sh).a("deliveryLatencyMicros", this.ts).a("timeOutMicros", this.ty).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.a((SensorRequest)that);
    }

    private boolean a(SensorRequest sensorRequest) {
        return l.equal(this.rc, sensorRequest.rc) && l.equal(this.rb, sensorRequest.rb) && this.sh == sensorRequest.sh && this.tt == sensorRequest.tt && this.ts == sensorRequest.ts && this.si == sensorRequest.si && l.equal(this.tx, sensorRequest.tx) && this.ty == sensorRequest.ty;
    }

    public int hashCode() {
        return l.hashCode(this.rc, this.rb, this.sh, this.tt, this.ts, this.si, this.tx, this.ty);
    }

    public static int ao(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return n2;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource rc;
        private DataType rb;
        private long sh = -1L;
        private long tt = 0L;
        private long ts = 0L;
        private boolean tz = false;
        private int si = 2;
        private long ty = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.rc = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.rb = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            m.b(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.sh = unit.toMicros(interval);
            if (!this.tz) {
                this.tt = this.sh / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            m.b(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.tz = true;
            this.tt = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            m.b(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.ts = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.si = SensorRequest.ao(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            m.b(timeout > 0L, "Invalid time out value specified: %d", timeout);
            m.b(timeUnit != null, (Object)"Invalid time unit specified");
            this.ty = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            m.a(this.rc != null || this.rb != null, (Object)"Must call setDataSource() or setDataType()");
            m.a(this.rb == null || this.rc == null || this.rb.equals(this.rc.getDataType()), (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

