/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int nZ;
    private final long pl;
    private final long rd;
    private final List<DataSource> sZ;
    private final List<DataType> ro;
    private final List<Session> ta;
    private final boolean tb;
    private final boolean tc;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new d();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions) {
        this.nZ = versionCode;
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.sZ = Collections.unmodifiableList(dataSources);
        this.ro = Collections.unmodifiableList(dataTypes);
        this.ta = sessions;
        this.tb = deleteAllData;
        this.tc = deleteAllSessions;
    }

    private DataDeleteRequest(Builder builder) {
        this.nZ = 1;
        this.pl = builder.pl;
        this.rd = builder.rd;
        this.sZ = Collections.unmodifiableList(builder.sZ);
        this.ro = Collections.unmodifiableList(builder.ro);
        this.ta = Collections.unmodifiableList(builder.ta);
        this.tb = builder.tb;
        this.tc = builder.tc;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.pl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rd, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.sZ;
    }

    public List<DataType> getDataTypes() {
        return this.ro;
    }

    public List<Session> getSessions() {
        return this.ta;
    }

    public boolean deleteAllData() {
        return this.tb;
    }

    public boolean deleteAllSessions() {
        return this.tc;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataDeleteRequest && this.a((DataDeleteRequest)o2);
    }

    private boolean a(DataDeleteRequest dataDeleteRequest) {
        return this.pl == dataDeleteRequest.pl && this.rd == dataDeleteRequest.rd && l.equal(this.sZ, dataDeleteRequest.sZ) && l.equal(this.ro, dataDeleteRequest.ro) && l.equal(this.ta, dataDeleteRequest.ta) && this.tb == dataDeleteRequest.tb && this.tc == dataDeleteRequest.tc;
    }

    public int hashCode() {
        return l.hashCode(this.pl, this.rd);
    }

    public String toString() {
        return l.e(this).a("startTimeMillis", this.pl).a("endTimeMillis", this.rd).a("dataSources", this.sZ).a("dateTypes", this.ro).a("sessions", this.ta).a("deleteAllData", this.tb).a("deleteAllSessions", this.tc).toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    public boolean cJ() {
        return this.tb;
    }

    public boolean cK() {
        return this.tc;
    }

    public long ch() {
        return this.rd;
    }

    public long cg() {
        return this.pl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }

    public static class Builder {
        private long pl;
        private long rd;
        private List<DataSource> sZ = new ArrayList<DataSource>();
        private List<DataType> ro = new ArrayList<DataType>();
        private List<Session> ta = new ArrayList<Session>();
        private boolean tb = false;
        private boolean tc = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            m.b(startTime > 0L, "Invalid start time :%d", startTime);
            m.b(endTime > startTime, "Invalid end time :%d", endTime);
            this.pl = timeUnit.toMillis(startTime);
            this.rd = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            m.b(this.ro.isEmpty() && this.sZ.isEmpty(), "Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", this.sZ, this.ro);
            this.tb = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            m.b(!this.tb, (Object)"All data is already marked for deletion");
            m.b(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.sZ.contains(dataSource)) {
                this.sZ.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            m.b(!this.tc, (Object)"All sessions already marked for deletion");
            m.b(session != null, (Object)"Must specify a valid session");
            m.b(session.getEndTime(TimeUnit.MILLISECONDS) > 0L, (Object)"Must specify a session that has already ended");
            this.ta.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            m.b(this.ta.isEmpty(), "Specific sessions already added for deletion: %s", this.ta);
            this.tc = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            m.b(!this.tb, (Object)"All data is already marked for deletion");
            m.b(dataType != null, (Object)"Must specify a valid data type");
            if (!this.ro.contains(dataType)) {
                this.ro.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            m.a(this.pl > 0L && this.rd > this.pl, (Object)"Must specify a valid time interval");
            boolean bl2 = this.tb || !this.sZ.isEmpty() || !this.ro.isEmpty();
            boolean bl3 = this.tc || !this.ta.isEmpty();
            m.a(bl2 || bl3, (Object)"No data or session marked for deletion");
            this.cL();
            return new DataDeleteRequest(this);
        }

        private void cL() {
            if (this.ta.isEmpty()) {
                return;
            }
            for (Session session : this.ta) {
                m.a(session.getStartTime(TimeUnit.MILLISECONDS) >= this.pl && session.getEndTime(TimeUnit.MILLISECONDS) <= this.rd, "Session %s is outside the time interval [%d, %d]", session, this.pl, this.rd);
            }
        }
    }
}

