/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.u;

public final class Value
implements SafeParcelable {
    private final int nZ;
    private final int rV;
    private boolean sj;
    private float sk;
    public static final Parcelable.Creator<Value> CREATOR = new u();

    Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.nZ = versionCode;
        this.rV = format;
        this.sj = isSet;
        this.sk = value;
    }

    public void setInt(int value) {
        m.a(this.rV == 1, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.sj = true;
        this.sk = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        m.a(this.rV == 2, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.sj = true;
        this.sk = value;
    }

    public boolean isSet() {
        return this.sj;
    }

    public int getFormat() {
        return this.rV;
    }

    public int asInt() {
        m.a(this.rV == 1, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.sk);
    }

    public float asFloat() {
        m.a(this.rV == 2, (Object)"Value is not in float format");
        return this.sk;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Value && this.a((Value)o2);
    }

    private boolean a(Value value) {
        if (this.rV == value.rV && this.sj == value.sj) {
            switch (this.rV) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.sk == value.sk;
        }
        return false;
    }

    public int hashCode() {
        return l.hashCode(Float.valueOf(this.sk), this.rV, this.sj);
    }

    public String toString() {
        if (!this.sj) {
            return "unset";
        }
        switch (this.rV) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.nZ;
    }

    float cD() {
        return this.sk;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        u.a(this, dest, flags);
    }
}

