/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.n;
import com.google.android.gms.fitness.data.t;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawDataPoint
implements SafeParcelable {
    final int nZ;
    final long rt;
    final long ru;
    final Value[] rv;
    final int sa;
    final int sb;
    final long rx;
    final long ry;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new n();

    RawDataPoint(int versionCode, long timestampNanos, long startTimeNanos, Value[] values, int dataSourceIndex, int originalDataSourceIndex, long rawTimestamp, long insertionTimeMillis) {
        this.nZ = versionCode;
        this.rt = timestampNanos;
        this.ru = startTimeNanos;
        this.sa = dataSourceIndex;
        this.sb = originalDataSourceIndex;
        this.rx = rawTimestamp;
        this.ry = insertionTimeMillis;
        this.rv = values;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> dataSources) {
        this.nZ = 4;
        this.rt = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.ru = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.rv = dataPoint.cj();
        this.sa = t.a(dataPoint.getDataSource(), dataSources);
        this.sb = t.a(dataPoint.getOriginalDataSource(), dataSources);
        this.rx = dataPoint.ck();
        this.ry = dataPoint.cl();
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawDataPoint && this.a((RawDataPoint)o2);
    }

    private boolean a(RawDataPoint rawDataPoint) {
        return this.rt == rawDataPoint.rt && this.ru == rawDataPoint.ru && Arrays.equals(this.rv, rawDataPoint.rv) && this.sa == rawDataPoint.sa && this.sb == rawDataPoint.sb && this.rx == rawDataPoint.rx;
    }

    public int hashCode() {
        return l.hashCode(this.rt, this.ru);
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString(this.rv), this.ru, this.rt, this.sa, this.sb);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        n.a(this, parcel, flags);
    }
}

