/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.m;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int nZ;
    final long pl;
    final long rd;
    final Session rf;
    final int rZ;
    final List<RawDataSet> rq;
    final int rr;
    final boolean rs;
    public static final Parcelable.Creator<RawBucket> CREATOR = new m();

    RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.nZ = versionCode;
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.rf = session;
        this.rZ = activity;
        this.rq = dataSets;
        this.rr = bucketType;
        this.rs = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.nZ = 2;
        this.pl = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.rd = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.rf = bucket.getSession();
        this.rZ = bucket.ce();
        this.rr = bucket.getBucketType();
        this.rs = bucket.cf();
        List<DataSet> list = bucket.getDataSets();
        this.rq = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.rq.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawBucket && this.a((RawBucket)o2);
    }

    private boolean a(RawBucket rawBucket) {
        return this.pl == rawBucket.pl && this.rd == rawBucket.rd && this.rZ == rawBucket.rZ && l.equal(this.rq, rawBucket.rq) && this.rr == rawBucket.rr && this.rs == rawBucket.rs;
    }

    public int hashCode() {
        return l.hashCode(this.pl, this.rd, this.rr);
    }

    public String toString() {
        return l.e(this).a("startTime", this.pl).a("endTime", this.rd).a("activity", this.rZ).a("dataSets", this.rq).a("bucketType", this.rr).a("serverHasMoreData", this.rs).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        m.a(this, parcel, flags);
    }
}

