/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.g;
import com.google.android.gms.internal.aj;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int nZ;
    private final DataType rb;
    private final String mName;
    private final int rB;
    private final Device rC;
    private final a rD;
    private final String rE;
    private final boolean rF;
    private final String rG;
    public static final Parcelable.Creator<DataSource> CREATOR = new g();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, a application, String streamName, boolean isObfuscated) {
        this.nZ = versionCode;
        this.rb = dataType;
        this.rB = type;
        this.mName = name;
        this.rC = device;
        this.rD = application;
        this.rE = streamName;
        this.rF = isObfuscated;
        this.rG = this.cq();
    }

    private DataSource(Builder builder) {
        this.nZ = 3;
        this.rb = builder.rb;
        this.rB = builder.rB;
        this.mName = builder.mName;
        this.rC = builder.rC;
        this.rD = builder.rD;
        this.rE = builder.rE;
        this.rF = builder.rF;
        this.rG = this.cq();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.rb;
    }

    public int getType() {
        return this.rB;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.rD == null ? null : this.rD.getPackageName();
    }

    public a cp() {
        return this.rD;
    }

    public Device getDevice() {
        return this.rC;
    }

    public String getStreamName() {
        return this.rE;
    }

    public String getStreamIdentifier() {
        return this.rG;
    }

    private String cq() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.rb.getName());
        if (this.rD != null) {
            stringBuilder.append(":").append(this.rD.getPackageName());
        }
        if (this.rC != null) {
            stringBuilder.append(":").append(this.rC.getStreamIdentifier());
        }
        if (this.rE != null) {
            stringBuilder.append(":").append(this.rE);
        }
        return stringBuilder.toString();
    }

    public boolean cr() {
        return this.rF;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.a((DataSource)that);
    }

    private boolean a(DataSource dataSource) {
        return this.rG.equals(dataSource.rG);
    }

    public int hashCode() {
        return this.rG.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.rD != null) {
            stringBuilder.append(":").append(this.rD);
        }
        if (this.rC != null) {
            stringBuilder.append(":").append(this.rC);
        }
        if (this.rE != null) {
            stringBuilder.append(":").append(this.rE);
        }
        stringBuilder.append(":").append(this.rb);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.rB == 0 ? "r" : "d") + ":" + this.rb.ct() + (this.rD == null ? "" : (this.rD.equals(a.ri) ? ":gms" : ":" + this.rD.getPackageName())) + (this.rC != null ? ":" + this.rC.getModel() + ":" + this.rC.getUid() : "") + (this.rE != null ? ":" + this.rE : "");
    }

    private String getTypeString() {
        switch (this.rB) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    public DataSource cs() {
        Device device = this.rC == null ? null : this.rC.cw();
        a a2 = this.rD == null ? null : this.rD.cd();
        return new DataSource(3, this.rb, this.mName, this.rB, device, a2, aj.K(this.rE), this.rF);
    }

    int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = aj.c(this);
        g.a(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType rb;
        private int rB = -1;
        private String mName;
        private Device rC;
        private a rD;
        private String rE = "";
        private boolean rF = false;

        public Builder setDataType(DataType dataType) {
            this.rb = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.rB = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.rC = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.rD = new a(packageName, null, null);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            m.b(streamName != null, (Object)"Must specify a valid stream name");
            this.rE = streamName;
            return this;
        }

        public Builder setObfuscated(boolean isObfuscated) {
            this.rF = isObfuscated;
            return this;
        }

        public DataSource build() {
            m.a(this.rb != null, (Object)"Must set data type");
            m.a(this.rB >= 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

