/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataSet
implements SafeParcelable {
    private final int nZ;
    private final DataSource rc;
    private final DataType rb;
    private final List<DataPoint> rz;
    private final List<DataSource> rA;
    private boolean rs = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new f();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.nZ = versionCode;
        this.rc = dataSource;
        this.rb = dataType;
        this.rs = serverHasMoreData;
        this.rz = new ArrayList<DataPoint>(dataPoints.size());
        this.rA = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.rz.add(new DataPoint(this.rA, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource, DataType dataType) {
        this.nZ = 3;
        this.rc = m.f(dataSource);
        this.rb = m.f(dataType);
        this.rz = new ArrayList<DataPoint>();
        this.rA = new ArrayList<DataSource>();
        this.rA.add(this.rc);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(3, DataSet.b(uniqueDataSources, dataSet.sa), DataSet.b(uniqueDataTypes, dataSet.sc), dataSet.sd, uniqueDataSources, dataSet.rs);
    }

    private static <T> T b(List<T> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? (T)list.get(n2) : null;
    }

    public static DataSet create(DataSource dataSource) {
        m.a(dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource, dataSource.getDataType());
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.rc);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        m.b(dataSource.getStreamIdentifier().equals(this.rc.getStreamIdentifier()), "Conflicting data sources found %s vs %s", dataSource, this.rc);
        m.b(dataPoint.getDataType().getName().equals(this.rb.getName()), "Conflicting data types found %s vs %s", dataPoint.getDataType(), this.rb);
        m.b(dataPoint.getTimestamp(TimeUnit.NANOSECONDS) > 0L, "Data point does not have the timestamp set: %s", dataPoint);
        m.b(dataPoint.getStartTime(TimeUnit.NANOSECONDS) <= dataPoint.getEndTime(TimeUnit.NANOSECONDS), "Data point with start time greater than end time found: %s", dataPoint);
        this.b(dataPoint);
    }

    public void b(DataPoint dataPoint) {
        this.rz.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.rA.contains(dataSource)) {
            this.rA.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void a(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.b(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.rc;
    }

    public DataType getDataType() {
        return this.rb;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.rz);
    }

    public boolean cf() {
        return this.rs;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataSet && this.a((DataSet)o2);
    }

    private boolean a(DataSet dataSet) {
        return l.equal(this.rb, dataSet.rb) && l.equal(this.rc, dataSet.rc) && l.equal(this.rz, dataSet.rz) && this.rs == dataSet.rs;
    }

    public int hashCode() {
        return l.hashCode(this.rb, this.rc);
    }

    public String toString() {
        List<RawDataPoint> list = this.cn();
        return String.format("DataSet{%s %s}", this.rc.toDebugString(), this.rz.size() < 10 ? list : String.format("%d data points, first 5: %s", this.rz.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.nZ;
    }

    List<RawDataPoint> cn() {
        return this.b(this.rA);
    }

    List<RawDataPoint> b(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.rz.size());
        for (DataPoint dataPoint : this.rz) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> co() {
        return this.rA;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        f.a(this, parcel, flags);
    }
}

