/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType rb;
        private DataSource rc;
        private long pl;
        private long rd;
        private String re;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.rb = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.pl = timeUnit.toMillis(start);
            this.rd = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            m.b(dataSource.getDataType().equals(this.rb), "Data source %s is not for the data type %s", dataSource, this.rb);
            this.rc = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.re = packageName;
            return this;
        }

        public Intent build() {
            m.a(this.pl > 0L, (Object)"Start time must be set");
            m.a(this.rd > this.pl, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.rc.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.pl);
            intent.putExtra("vnd.google.fitness.end_time", this.rd);
            c.a(this.rc, intent, "vnd.google.fitness.data_source");
            return this.b(intent);
        }

        private Intent b(Intent intent) {
            if (this.re == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.re);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string2 = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.re, string2));
                return intent2;
            }
            return intent;
        }
    }
}

