/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int nZ;
    private final Uri ph;
    private final int pi;
    private final int pj;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.nZ = versionCode;
        this.ph = url;
        this.pi = width;
        this.pj = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    int getVersionCode() {
        return this.nZ;
    }

    public Uri getUrl() {
        return this.ph;
    }

    public int getWidth() {
        return this.pi;
    }

    public int getHeight() {
        return this.pj;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.pi, this.pj, this.ph.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return l.equal(this.ph, webImage.ph) && this.pi == webImage.pi && this.pj == webImage.pj;
    }

    public int hashCode() {
        return l.hashCode(this.ph, this.pi, this.pj);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

