/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.m;

public class c
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean ob;
    private int oc = -1;
    private ConnectionResult od;
    private final Handler oe = new Handler(Looper.getMainLooper());
    private final SparseArray<b> of = new SparseArray();

    public static c a(FragmentActivity fragmentActivity) {
        c c2;
        m.A("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            c2 = (c)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (c2 == null || c2.isRemoving()) {
            c2 = new c();
            fragmentManager.beginTransaction().add((Fragment)c2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return c2;
    }

    public GoogleApiClient p(int n2) {
        a a2;
        if (this.getActivity() != null && (a2 = this.r(n2)) != null) {
            return a2.og;
        }
        return null;
    }

    public void a(int n2, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        m.a(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        m.a(this.of.indexOfKey(n2) < 0, (Object)("Already managing a GoogleApiClient with id " + n2));
        b b2 = new b(googleApiClient, onConnectionFailedListener);
        this.of.put(n2, (Object)b2);
        if (this.getActivity() != null) {
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void q(int n2) {
        this.getLoaderManager().destroyLoader(n2);
        this.of.remove(n2);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.b(this.oc, this.od);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i2 = 0; i2 < this.of.size(); ++i2) {
            int n2 = this.of.keyAt(i2);
            a a2 = this.r(n2);
            if (a2 != null) {
                b b2 = (b)this.of.valueAt(i2);
                if (b2.og != a2.og) {
                    this.getLoaderManager().restartLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.ob = savedInstanceState.getBoolean("resolving_error", false);
            this.oc = savedInstanceState.getInt("failed_client_id", -1);
            if (this.oc >= 0) {
                this.od = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.ob);
        if (this.oc >= 0) {
            outState.putInt("failed_client_id", this.oc);
            outState.putInt("failed_status", this.od.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.od.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.ob) {
            for (int i2 = 0; i2 < this.of.size(); ++i2) {
                this.getLoaderManager().initLoader(this.of.keyAt(i2), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl2 = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl2 = true;
            }
        }
        if (bl2) {
            this.bu();
        } else {
            this.b(this.oc, this.od);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new a((Context)this.getActivity(), ((b)this.of.get((int)id)).og);
    }

    public void a(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.s(loader.getId());
        } else {
            this.a(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
        if (loader.getId() == this.oc) {
            this.bu();
        }
    }

    a r(int n2) {
        try {
            return (a)this.getLoaderManager().getLoader(n2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void s(int n2) {
        if (n2 == this.oc) {
            this.bu();
        }
    }

    private void a(int n2, ConnectionResult connectionResult) {
        if (!this.ob) {
            this.ob = true;
            this.oc = n2;
            this.od = connectionResult;
            this.oe.post((Runnable)new c(n2, connectionResult));
        }
    }

    private void b(int n2, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        b b2 = (b)this.of.get(n2);
        if (b2 != null) {
            this.q(n2);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = b2.oj;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.bu();
    }

    private void bu() {
        this.ob = false;
        this.oc = -1;
        this.od = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i2 = 0; i2 < this.of.size(); ++i2) {
            int n2 = this.of.keyAt(i2);
            a a2 = this.r(n2);
            if (a2 != null) {
                a2.bv();
            }
            loaderManager.initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.a((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class a
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient og;
        private boolean oh;
        private ConnectionResult oi;

        public a(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.og = googleApiClient;
        }

        public void bv() {
            if (this.oh) {
                this.oh = false;
                if (this.isStarted() && !this.isAbandoned()) {
                    this.og.connect();
                }
            }
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.og.registerConnectionCallbacks(this);
            this.og.registerConnectionFailedListener(this);
            if (this.oi != null) {
                this.deliverResult(this.oi);
            }
            if (!(this.og.isConnected() || this.og.isConnecting() || this.oh)) {
                this.og.connect();
            }
        }

        protected void onStopLoading() {
            this.og.disconnect();
        }

        protected void onReset() {
            this.oi = null;
            this.oh = false;
            this.og.unregisterConnectionCallbacks(this);
            this.og.unregisterConnectionFailedListener(this);
            this.og.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.oh = false;
            this.a(ConnectionResult.mf);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.oh = true;
            this.a(result);
        }

        private void a(ConnectionResult connectionResult) {
            this.oi = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class b {
        public final GoogleApiClient og;
        public final GoogleApiClient.OnConnectionFailedListener oj;

        private b(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.og = googleApiClient;
            this.oj = onConnectionFailedListener;
        }
    }

    private class c
    implements Runnable {
        private final int ok;
        private final ConnectionResult ol;

        public c(int n2, ConnectionResult connectionResult) {
            this.ok = n2;
            this.ol = connectionResult;
        }

        @Override
        public void run() {
            if (this.ol.hasResolution()) {
                try {
                    int n2 = c.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)c.this);
                    int n3 = 1 + (1 + n2 << 16);
                    this.ol.startResolutionForResult((Activity)c.this.getActivity(), n3);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    c.this.bu();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.ol.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.ol.getErrorCode(), (Activity)c.this.getActivity(), c.this, 2, c.this);
            } else {
                c.this.b(this.ok, this.ol);
            }
        }
    }
}

