/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.m;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class a
implements GoogleApiClient {
    final int nv;
    private final Lock nw = new ReentrantLock();
    private final Condition nx = this.nw.newCondition();
    private final e ny;
    private final int nz;
    private final Looper nj;
    final Queue<c<?>> nA = new LinkedList();
    private ConnectionResult nB;
    private int nC;
    private volatile int nD = 4;
    private volatile int nE;
    private boolean nF = false;
    private int nG;
    private long nH = 5000L;
    final Handler nI;
    private final Bundle nJ = new Bundle();
    private final Map<Api.c<?>, Api.a> nK = new HashMap();
    private final List<String> nL;
    private boolean nM;
    private final Set<com.google.android.gms.common.api.b<?>> nN = Collections.newSetFromMap(new WeakHashMap());
    final Set<c<?>> nO = Collections.newSetFromMap(new ConcurrentHashMap());
    private final a nb = new a(){

        @Override
        public void b(c<?> c2) {
            a.this.nO.remove(c2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks nP = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            a.this.nw.lock();
            try {
                if (a.this.nD == 1) {
                    if (connectionHint != null) {
                        a.this.nJ.putAll(connectionHint);
                    }
                    a.this.bn();
                }
            }
            finally {
                a.this.nw.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            a.this.nw.lock();
            try {
                a.this.o(cause);
                switch (cause) {
                    case 2: {
                        a.this.connect();
                        return;
                    }
                    case 1: {
                        if (a.this.bp()) {
                            return;
                        }
                        a.this.nE = a.this.nv;
                        a.this.nI.sendMessageDelayed(a.this.nI.obtainMessage(1), a.this.nH);
                        return;
                    }
                }
                return;
            }
            finally {
                a.this.nw.unlock();
            }
        }
    };
    private final e.b nQ = new e.b(){

        @Override
        public boolean br() {
            return a.this.nM;
        }

        @Override
        public boolean isConnected() {
            return a.this.isConnected();
        }

        @Override
        public Bundle bs() {
            return null;
        }
    };

    public a(Context context, Looper looper, ClientSettings clientSettings, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n2, int n3) {
        this.ny = new e(context, looper, this.nQ);
        this.nj = looper;
        this.nI = new b(looper);
        this.nz = n2;
        this.nv = n3;
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.ny.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.ny.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b b2 = api.bd();
            Api.ApiOptions apiOptions = map.get(api);
            this.nK.put(api.bf(), (Api.a)a.a(b2, apiOptions, context, looper, clientSettings, this.nP, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    a.this.nw.lock();
                    try {
                        if (a.this.nB == null || b2.getPriority() < a.this.nC) {
                            a.this.nB = result;
                            a.this.nC = b2.getPriority();
                        }
                        a.this.bn();
                    }
                    finally {
                        a.this.nw.unlock();
                    }
                }
            }));
        }
        this.nL = Collections.unmodifiableList(clientSettings.getScopes());
    }

    private static <C extends Api.a, O> C a(Api.b<C, O> b2, Object object, Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return b2.a(context, looper, clientSettings, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void bn() {
        --this.nG;
        if (this.nG == 0) {
            if (this.nB != null) {
                this.nF = false;
                this.o(3);
                if (this.bp()) {
                    this.nI.sendMessageDelayed(this.nI.obtainMessage(1), this.nH);
                } else {
                    this.ny.b(this.nB);
                }
                this.nM = false;
            } else {
                this.nD = 2;
                this.bq();
                this.nx.signalAll();
                this.bo();
                if (this.nF) {
                    this.nF = false;
                    this.o(-1);
                } else {
                    Bundle bundle = this.nJ.isEmpty() ? null : this.nJ;
                    this.ny.a(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T t2) {
        this.nw.lock();
        try {
            t2.a(new BaseImplementation.CallbackHandler(this.getLooper()));
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.nA.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.nw.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T t2) {
        m.a(this.isConnected() || this.bp(), (Object)"GoogleApiClient is not connected yet.");
        this.bo();
        try {
            this.a((c<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.o(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(c<A> c2) throws DeadObjectException {
        this.nw.lock();
        try {
            m.b(c2.bf() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.nO.add(c2);
            c2.a(this.nb);
            if (this.bp()) {
                c2.b(new Status(8));
                return;
            }
            A a2 = this.a(c2.bf());
            c2.a(a2);
        }
        finally {
            this.nw.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bo() {
        this.nw.lock();
        try {
            m.a(this.isConnected() || this.bp(), (Object)"GoogleApiClient is not connected yet.");
            while (!this.nA.isEmpty()) {
                try {
                    this.a(this.nA.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.nw.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.c<C> c2) {
        Api.a a2 = this.nK.get(c2);
        m.a(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.nw.lock();
        try {
            this.nF = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.nM = true;
            this.nB = null;
            this.nD = 1;
            this.nJ.clear();
            this.nG = this.nK.size();
            for (Api.a a2 : this.nK.values()) {
                a2.connect();
            }
        }
        finally {
            this.nw.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        m.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.nw.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.nx.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.nw.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.mf;
                return connectionResult;
            }
            if (this.nB != null) {
                ConnectionResult connectionResult = this.nB;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.nw.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        m.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.nw.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.nx.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.mf;
                return connectionResult;
            }
            if (this.nB != null) {
                ConnectionResult connectionResult = this.nB;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.nw.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.bq();
        this.o(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o(int n2) {
        this.nw.lock();
        try {
            if (this.nD != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.nA.iterator();
                        while (iterator.hasNext()) {
                            c object = (c)iterator.next();
                            if (object.bk() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        this.nA.clear();
                    }
                    for (c c2 : this.nO) {
                        c2.cancel();
                    }
                    this.nO.clear();
                    for (com.google.android.gms.common.api.b b2 : this.nN) {
                        b2.clear();
                    }
                    this.nN.clear();
                    if (this.nB == null && !this.nA.isEmpty()) {
                        this.nF = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.nD = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.nB = null;
                    }
                    this.nx.signalAll();
                }
                this.nM = false;
                for (Api.a a2 : this.nK.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.nM = true;
                this.nD = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.ny.D(n2);
                    }
                    this.nM = false;
                }
            }
        }
        finally {
            this.nw.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        m.a(this.nz >= 0, (Object)"Called stopAutoManage but automatic lifecycle management is not enabled.");
        com.google.android.gms.common.api.c.a(lifecycleActivity).q(this.nz);
    }

    @Override
    public boolean isConnected() {
        return this.nD == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.nD == 1;
    }

    private boolean bp() {
        return this.nE != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bq() {
        this.nw.lock();
        try {
            this.nE = 0;
            this.nI.removeMessages(1);
        }
        finally {
            this.nw.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.ny.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.ny.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.ny.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.ny.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.ny.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.ny.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Looper getLooper() {
        return this.nj;
    }

    class b
    extends Handler {
        b(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                a.this.nw.lock();
                try {
                    if (a.this.isConnected() || a.this.isConnecting() || !a.this.bp()) {
                        return;
                    }
                    a.this.nE--;
                    a.this.connect();
                    return;
                }
                finally {
                    a.this.nw.unlock();
                }
            }
            Log.wtf((String)"GoogleApiClientImpl", (String)"Don't know how to handle this message.");
        }
    }

    static interface c<A extends Api.a> {
        public void cancel();

        public Api.c<A> bf();

        public void a(A var1) throws DeadObjectException;

        public void b(Status var1);

        public void a(a var1);

        public int bk();
    }

    static interface a {
        public void b(c<?> var1);
    }
}

