/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.cg;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cq
implements o.f {
    private final Context mContext;
    private final String AP;
    private final ExecutorService Dr;
    private bg<cg.a> Dk;

    cq(Context context, String string) {
        this.mContext = context;
        this.AP = string;
        this.Dr = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<cg.a> bg2) {
        this.Dk = bg2;
    }

    @Override
    public void eJ() {
        this.Dr.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.fy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fy() {
        if (this.Dk == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.Dk.eI();
        bh.o("Attempting to load resource from disk");
        if ((ce.fq().fr() == ce.a.CZ || ce.fq().fr() == ce.a.Da) && this.AP.equals(ce.fq().getContainerId())) {
            this.Dk.a(bg.a.CD);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fz());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.ah("Failed to find the resource in the disk");
            this.Dk.a(bg.a.CD);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(fileInputStream, byteArrayOutputStream);
            cg.a a2 = cg.a.g(byteArrayOutputStream.toByteArray());
            this.d(a2);
            this.Dk.h(a2);
        }
        catch (IOException iOException) {
            this.Dk.a(bg.a.CE);
            bh.p("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.Dk.a(bg.a.CE);
            bh.p("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.p("Error closing stream for reading resource from disk");
            }
        }
        bh.o("The Disk resource was successfully read.");
    }

    @Override
    public void b(final cg.a a2) {
        this.Dr.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.c(a2);
            }
        });
    }

    @Override
    public cr.c bw(int n2) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.p("Failed to load the container. No default container resource found with the resource ID " + n2);
            return null;
        }
        bh.o("Attempting to load a container from the resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(inputStream, byteArrayOutputStream);
            cr.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                bh.o("The container was successfully loaded from the resource (using JSON file format)");
                return c2;
            }
            return this.f(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.p("Error reading the default container with resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
            return null;
        }
    }

    private cr.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return ba.ap(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.ah("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            bh.p("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cr.c f(byte[] byArray) {
        try {
            cr.c c2 = cr.b(c.f.a(byArray));
            if (c2 != null) {
                bh.o("The container was successfully loaded from the resource (using binary file)");
            }
            return c2;
        }
        catch (com.google.android.gms.internal.cq cq2) {
            bh.m("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (cr.g g2) {
            bh.p("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.Dr.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(cg.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.fz();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.m("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(com.google.android.gms.internal.cr.f(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.p("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.p("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File fz() {
        String string = "resource_" + this.AP;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void d(cg.a a2) throws IllegalArgumentException {
        if (a2.fY == null && a2.Fj == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

