/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ag;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.br;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.ct;
import com.google.android.gms.tagmanager.di;
import com.google.android.gms.tagmanager.s;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String AP;
    private final DataLayer AQ;
    private ct AR;
    private Map<String, FunctionCallMacroCallback> AS = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> AT = new HashMap<String, FunctionCallTagCallback>();
    private volatile long AU;
    private volatile String AV = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, cr.c resource) {
        this.mContext = context;
        this.AQ = dataLayer;
        this.AP = containerId;
        this.AU = lastRefreshTime;
        this.a(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, c.j resource) {
        this.mContext = context;
        this.AQ = dataLayer;
        this.AP = containerId;
        this.AU = lastRefreshTime;
        this.a(resource.fY);
        if (resource.fX != null) {
            this.a(resource.fX);
        }
    }

    public String getContainerId() {
        return this.AP;
    }

    public boolean getBoolean(String key) {
        ct ct2 = this.eA();
        if (ct2 == null) {
            bh.m("getBoolean called for closed container.");
            return di.gp();
        }
        try {
            return di.n(ct2.aA(key).getObject());
        }
        catch (Exception exception) {
            bh.m("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.gp();
        }
    }

    public double getDouble(String key) {
        ct ct2 = this.eA();
        if (ct2 == null) {
            bh.m("getDouble called for closed container.");
            return di.go();
        }
        try {
            return di.m(ct2.aA(key).getObject());
        }
        catch (Exception exception) {
            bh.m("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.go();
        }
    }

    public long getLong(String key) {
        ct ct2 = this.eA();
        if (ct2 == null) {
            bh.m("getLong called for closed container.");
            return di.gn();
        }
        try {
            return di.l(ct2.aA(key).getObject());
        }
        catch (Exception exception) {
            bh.m("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.gn();
        }
    }

    public String getString(String key) {
        ct ct2 = this.eA();
        if (ct2 == null) {
            bh.m("getString called for closed container.");
            return di.gr();
        }
        try {
            return di.j(ct2.aA(key).getObject());
        }
        catch (Exception exception) {
            bh.m("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.gr();
        }
    }

    public long getLastRefreshTime() {
        return this.AU;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.AS;
        synchronized (map) {
            this.AS.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.AS;
        synchronized (map) {
            this.AS.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback V(String string) {
        Map<String, FunctionCallMacroCallback> map = this.AS;
        synchronized (map) {
            return this.AS.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.AT;
        synchronized (map) {
            this.AT.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.AT;
        synchronized (map) {
            this.AT.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback W(String string) {
        Map<String, FunctionCallTagCallback> map = this.AT;
        synchronized (map) {
            return this.AT.get(string);
        }
    }

    void X(String string) {
        this.eA().X(string);
    }

    String ez() {
        return this.AV;
    }

    private void a(c.f f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        cr.c c2 = null;
        try {
            c2 = cr.b(f2);
        }
        catch (cr.g g2) {
            bh.m("Not loading resource: " + f2 + " because it is invalid: " + g2.toString());
            return;
        }
        this.a(c2);
    }

    private void a(c.i[] iArray) {
        ArrayList<c.i> arrayList = new ArrayList<c.i>();
        for (c.i i2 : iArray) {
            arrayList.add(i2);
        }
        this.eA().h(arrayList);
    }

    private void a(cr.c c2) {
        this.AV = c2.getVersion();
        ag ag2 = this.Y(this.AV);
        ct ct2 = new ct(this.mContext, c2, this.AQ, new a(), new b(), ag2);
        this.a(ct2);
    }

    ag Y(String string) {
        if (ce.fq().fr().equals((Object)ce.a.Da)) {
            // empty if block
        }
        return new br();
    }

    private synchronized void a(ct ct2) {
        this.AR = ct2;
    }

    private synchronized ct eA() {
        return this.AR;
    }

    void release() {
        this.AR = null;
    }

    private class b
    implements s.a {
        private b() {
        }

        @Override
        public Object a(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.W(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return di.gr();
        }
    }

    private class a
    implements s.a {
        private a() {
        }

        @Override
        public Object a(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.V(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

