/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.m;
import com.google.android.gms.maps.model.n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final m CREATOR = new m();
    private final int nS;
    private final List<LatLng> Aj;
    private final List<List<LatLng>> Ak;
    private float zF = 10.0f;
    private int zG = -16777216;
    private int zH = 0;
    private float zI = 0.0f;
    private boolean zJ = true;
    private boolean Al = false;

    public PolygonOptions() {
        this.nS = 1;
        this.Aj = new ArrayList<LatLng>();
        this.Ak = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.nS = versionCode;
        this.Aj = points;
        this.Ak = holes;
        this.zF = strokeWidth;
        this.zG = strokeColor;
        this.zH = fillColor;
        this.zI = zIndex;
        this.zJ = visible;
        this.Al = geodesic;
    }

    int getVersionCode() {
        return this.nS;
    }

    List en() {
        return this.Ak;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.ej()) {
            n.a(this, out, flags);
        } else {
            m.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.Aj.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.Aj.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Aj.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.Ak.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zF = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zG = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zH = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zI = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zJ = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.Al = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Aj;
    }

    public List<List<LatLng>> getHoles() {
        return this.Ak;
    }

    public float getStrokeWidth() {
        return this.zF;
    }

    public int getStrokeColor() {
        return this.zG;
    }

    public int getFillColor() {
        return this.zH;
    }

    public float getZIndex() {
        return this.zI;
    }

    public boolean isVisible() {
        return this.zJ;
    }

    public boolean isGeodesic() {
        return this.Al;
    }
}

