/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.e;
import com.google.android.gms.maps.model.f;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final e CREATOR = new e();
    public static final float NO_DIMENSION = -1.0f;
    private final int nS;
    private BitmapDescriptor zL;
    private LatLng zM;
    private float zN;
    private float zO;
    private LatLngBounds zP;
    private float zB;
    private float zI;
    private boolean zJ = true;
    private float zQ = 0.0f;
    private float zR = 0.5f;
    private float zS = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.nS = versionCode;
        this.zL = new BitmapDescriptor(b.a.k(wrappedImage));
        this.zM = location;
        this.zN = width;
        this.zO = height;
        this.zP = bounds;
        this.zB = bearing;
        this.zI = zIndex;
        this.zJ = visible;
        this.zQ = transparency;
        this.zR = anchorU;
        this.zS = anchorV;
    }

    public GroundOverlayOptions() {
        this.nS = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.ej()) {
            f.a(this, out, flags);
        } else {
            e.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder el() {
        return this.zL.dL().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zL = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.zR = u2;
        this.zS = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        l.a(this.zP == null, (Object)"Position has already been set using positionFromBounds");
        l.b(location != null, (Object)"Location must be specified");
        l.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        l.a(this.zP == null, (Object)"Position has already been set using positionFromBounds");
        l.b(location != null, (Object)"Location must be specified");
        l.b(width >= 0.0f, (Object)"Width must be non-negative");
        l.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.zM = latLng;
        this.zN = f2;
        this.zO = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        l.a(this.zM == null, (Object)("Position has already been set using position: " + this.zM));
        this.zP = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zB = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zI = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zJ = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        l.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.zQ = transparency;
        return this;
    }

    int getVersionCode() {
        return this.nS;
    }

    public BitmapDescriptor getImage() {
        return this.zL;
    }

    public LatLng getLocation() {
        return this.zM;
    }

    public float getWidth() {
        return this.zN;
    }

    public float getHeight() {
        return this.zO;
    }

    public LatLngBounds getBounds() {
        return this.zP;
    }

    public float getBearing() {
        return this.zB;
    }

    public float getZIndex() {
        return this.zI;
    }

    public float getTransparency() {
        return this.zQ;
    }

    public float getAnchorU() {
        return this.zR;
    }

    public float getAnchorV() {
        return this.zS;
    }

    public boolean isVisible() {
        return this.zJ;
    }
}

