/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.maps.internal.IStreetViewPanoramaDelegate;
import com.google.android.gms.maps.internal.p;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.StreetViewPanoramaCamera;
import com.google.android.gms.maps.model.StreetViewPanoramaLocation;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;

public class StreetViewPanorama {
    private final IStreetViewPanoramaDelegate yY;

    protected StreetViewPanorama(IStreetViewPanoramaDelegate sv) {
        this.yY = l.f(sv);
    }

    IStreetViewPanoramaDelegate dZ() {
        return this.yY;
    }

    public boolean isZoomGesturesEnabled() {
        try {
            return this.yY.isZoomGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setZoomGesturesEnabled(boolean enableZoom) {
        try {
            this.yY.enableZoom(enableZoom);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isPanningGesturesEnabled() {
        try {
            return this.yY.isPanningGesturesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPanningGesturesEnabled(boolean enablePanning) {
        try {
            this.yY.enablePanning(enablePanning);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isUserNavigationEnabled() {
        try {
            return this.yY.isUserNavigationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setUserNavigationEnabled(boolean enableUserNavigation) {
        try {
            this.yY.enableUserNavigation(enableUserNavigation);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isStreetNamesEnabled() {
        try {
            return this.yY.isStreetNamesEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setStreetNamesEnabled(boolean enableStreetNames) {
        try {
            this.yY.enableStreetNames(enableStreetNames);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void animateTo(StreetViewPanoramaCamera camera, long duration) {
        try {
            this.yY.animateTo(camera, duration);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaCamera getPanoramaCamera() {
        try {
            return this.yY.getPanoramaCamera();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(String panoId) {
        try {
            this.yY.setPositionWithID(panoId);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(LatLng position) {
        try {
            this.yY.setPosition(position);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setPosition(LatLng position, int radius) {
        try {
            this.yY.setPositionWithRadius(position, radius);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaLocation getLocation() {
        try {
            return this.yY.getStreetViewPanoramaLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public StreetViewPanoramaOrientation pointToOrientation(Point point) {
        try {
            return this.yY.pointToOrientation(c.g(point));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public Point orientationToPoint(StreetViewPanoramaOrientation orientation) {
        try {
            b b2 = this.yY.orientationToPoint(orientation);
            if (b2 == null) {
                return null;
            }
            return (Point)c.a(b2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaChangeListener(final OnStreetViewPanoramaChangeListener listener) {
        try {
            if (listener == null) {
                this.yY.setOnStreetViewPanoramaChangeListener(null);
            } else {
                this.yY.setOnStreetViewPanoramaChangeListener(new q.a(){

                    @Override
                    public void onStreetViewPanoramaChange(StreetViewPanoramaLocation location) {
                        listener.onStreetViewPanoramaChange(location);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaCameraChangeListener(final OnStreetViewPanoramaCameraChangeListener listener) {
        try {
            if (listener == null) {
                this.yY.setOnStreetViewPanoramaCameraChangeListener(null);
            } else {
                this.yY.setOnStreetViewPanoramaCameraChangeListener(new p.a(){

                    @Override
                    public void onStreetViewPanoramaCameraChange(StreetViewPanoramaCamera camera) {
                        listener.onStreetViewPanoramaCameraChange(camera);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnStreetViewPanoramaClickListener(final OnStreetViewPanoramaClickListener listener) {
        try {
            if (listener == null) {
                this.yY.setOnStreetViewPanoramaClickListener(null);
            } else {
                this.yY.setOnStreetViewPanoramaClickListener(new r.a(){

                    @Override
                    public void onStreetViewPanoramaClick(StreetViewPanoramaOrientation orientation) {
                        listener.onStreetViewPanoramaClick(orientation);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static interface OnStreetViewPanoramaClickListener {
        public void onStreetViewPanoramaClick(StreetViewPanoramaOrientation var1);
    }

    public static interface OnStreetViewPanoramaCameraChangeListener {
        public void onStreetViewPanoramaCameraChange(StreetViewPanoramaCamera var1);
    }

    public static interface OnStreetViewPanoramaChangeListener {
        public void onStreetViewPanoramaChange(StreetViewPanoramaLocation var1);
    }
}

