/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.u;

public final class k
extends Drawable
implements Drawable.Callback {
    private int pd = 0;
    private long pe;
    private int mFrom;
    private int pf;
    private int pg = 255;
    private int ph;
    private int pi = 0;
    private boolean oV = true;
    private boolean pj;
    private b pk;
    private Drawable pl;
    private Drawable pm;
    private boolean pn;
    private boolean po;
    private boolean pp;
    private int pq;

    public k(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = a.pr;
        }
        this.pl = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.pk.pu |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = a.pr;
        }
        this.pm = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.pk.pu |= drawable3.getChangingConfigurations();
    }

    k(b b2) {
        this.pk = new b(b2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (u.bU() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (u.bU() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (u.bU() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.pk.pt | this.pk.pu;
    }

    public void setAlpha(int alpha) {
        if (this.pi == this.pg) {
            this.pi = alpha;
        }
        this.pg = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf2) {
        this.pl.setColorFilter(cf2);
        this.pm.setColorFilter(cf2);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.pl.getIntrinsicWidth(), this.pm.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.pl.getIntrinsicHeight(), this.pm.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.pl.setBounds(bounds);
        this.pm.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.pk.pt = this.getChangingConfigurations();
            return this.pk;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.pp) {
            this.pq = Drawable.resolveOpacity((int)this.pl.getOpacity(), (int)this.pm.getOpacity());
            this.pp = true;
        }
        return this.pq;
    }

    public boolean canConstantState() {
        if (!this.pn) {
            this.po = this.pl.getConstantState() != null && this.pm.getConstantState() != null;
            this.pn = true;
        }
        return this.po;
    }

    public Drawable mutate() {
        if (!this.pj && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.pl.mutate();
            this.pm.mutate();
            this.pj = true;
        }
        return this;
    }

    public Drawable bH() {
        return this.pm;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.pf = this.pg;
        this.pi = 0;
        this.ph = durationMillis;
        this.pd = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl2 = true;
        switch (this.pd) {
            case 1: {
                this.pe = SystemClock.uptimeMillis();
                bl2 = false;
                this.pd = 2;
                break;
            }
            case 2: {
                if (this.pe < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.pe) / (float)this.ph;
                boolean bl3 = bl2 = f2 >= 1.0f;
                if (bl2) {
                    this.pd = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.pi = (int)((float)this.mFrom + (float)(this.pf - this.mFrom) * f2);
            }
        }
        int n2 = this.pi;
        boolean bl4 = this.oV;
        Drawable drawable2 = this.pl;
        Drawable drawable3 = this.pm;
        if (bl2) {
            if (!bl4 || n2 == 0) {
                drawable2.draw(canvas);
            }
            if (n2 == this.pg) {
                drawable3.setAlpha(this.pg);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl4) {
            drawable2.setAlpha(this.pg - n2);
        }
        drawable2.draw(canvas);
        if (bl4) {
            drawable2.setAlpha(this.pg);
        }
        if (n2 > 0) {
            drawable3.setAlpha(n2);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.pg);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.k$a
    extends Drawable {
        private static final com.google.android.gms.internal.k$a pr = new com.google.android.gms.internal.k$a();
        private static final a ps = new a();

        private com.google.android.gms.internal.k$a() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf2) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return ps;
        }

        private static final class a
        extends Drawable.ConstantState {
            private a() {
            }

            public Drawable newDrawable() {
                return pr;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class b
    extends Drawable.ConstantState {
        int pt;
        int pu;

        b(b b2) {
            if (b2 != null) {
                this.pt = b2.pt;
                this.pu = b2.pu;
            }
        }

        public Drawable newDrawable() {
            return new k(this);
        }

        public int getChangingConfigurations() {
            return this.pt;
        }
    }
}

