/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.q;
import com.google.android.gms.fitness.result.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int nS;
    private final List<Session> sP;
    private final List<q> tE;
    private final Status kW;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new f();

    SessionReadResult(int versionCode, List<Session> sessions, List<q> sessionDataSets, Status status) {
        this.nS = versionCode;
        this.sP = sessions;
        this.tE = Collections.unmodifiableList(sessionDataSets);
        this.kW = status;
    }

    public SessionReadResult(List<Session> sessions, List<q> sessionDataSets, Status status) {
        this.nS = 3;
        this.sP = sessions;
        this.tE = Collections.unmodifiableList(sessionDataSets);
        this.kW = status;
    }

    public static SessionReadResult q(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<q> arrayList2 = new ArrayList<q>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.sP;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        l.b(this.sP.contains(session), "Attempting to read data for session %s which was not returned", session);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (q q2 : this.tE) {
            if (!k.equal(session, q2.getSession()) || !dataType.equals(q2.cr().getDataType())) continue;
            arrayList.add(q2.cr());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        l.b(this.sP.contains(session), "Attempting to read data for session %s which was not returned", session);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (q q2 : this.tE) {
            if (!k.equal(session, q2.getSession())) continue;
            arrayList.add(q2.cr());
        }
        return arrayList;
    }

    public List<q> dm() {
        return this.tE;
    }

    @Override
    public Status getStatus() {
        return this.kW;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.b((SessionReadResult)that);
    }

    private boolean b(SessionReadResult sessionReadResult) {
        return this.kW.equals(sessionReadResult.kW) && k.equal(this.sP, sessionReadResult.sP) && k.equal(this.tE, sessionReadResult.tE);
    }

    public int hashCode() {
        return k.hashCode(this.kW, this.sP, this.tE);
    }

    public String toString() {
        return k.e(this).a("status", this.kW).a("sessions", this.sP).a("sessionDataSets", this.tE).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }
}

