/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.s;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int nS;
    private final String tr;
    private final String ts;
    private final long pe;
    private final long qU;
    private final List<DataType> rh;
    private final List<DataSource> sO;
    private boolean tt;
    private final boolean sZ;
    private final List<String> tu;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new s();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages) {
        this.nS = versionCode;
        this.tr = sessionName;
        this.ts = sessionId;
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.rh = Collections.unmodifiableList(dataTypes);
        this.sO = Collections.unmodifiableList(dataSources);
        this.tt = getSessionsFromAllApps;
        this.sZ = serverQueriesEnabled;
        this.tu = excludedPackages;
    }

    private SessionReadRequest(Builder builder) {
        this.nS = 3;
        this.tr = builder.tr;
        this.ts = builder.ts;
        this.pe = builder.pe;
        this.qU = builder.qU;
        this.rh = Collections.unmodifiableList(builder.rh);
        this.sO = Collections.unmodifiableList(builder.sO);
        this.tt = builder.tt;
        this.sZ = builder.sZ;
        this.tu = builder.tu;
    }

    public String cW() {
        return this.tr;
    }

    public String cX() {
        return this.ts;
    }

    public long getStartTimeMillis() {
        return this.pe;
    }

    public long getEndTimeMillis() {
        return this.qU;
    }

    public List<DataType> getDataTypes() {
        return this.rh;
    }

    public List<DataSource> getDataSources() {
        return this.sO;
    }

    public boolean cY() {
        return this.tt;
    }

    public List<String> cZ() {
        return this.tu;
    }

    public boolean cI() {
        return this.sZ;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof SessionReadRequest && this.a((SessionReadRequest)o2);
    }

    private boolean a(SessionReadRequest sessionReadRequest) {
        return k.equal(this.tr, sessionReadRequest.tr) && this.ts.equals(sessionReadRequest.ts) && this.pe == sessionReadRequest.pe && this.qU == sessionReadRequest.qU && k.equal(this.rh, sessionReadRequest.rh) && k.equal(this.sO, sessionReadRequest.sO) && this.tt == sessionReadRequest.tt && this.tu.equals(sessionReadRequest.tu) && this.sZ == sessionReadRequest.sZ;
    }

    public int hashCode() {
        return k.hashCode(this.tr, this.ts, this.pe, this.qU);
    }

    public String toString() {
        return k.e(this).a("sessionName", this.tr).a("sessionId", this.ts).a("startTimeMillis", this.pe).a("endTimeMillis", this.qU).a("dataTypes", this.rh).a("dataSources", this.sO).a("sessionsFromAllApps", this.tt).a("excludedPackages", this.tu).a("useServer", this.sZ).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        s.a(this, dest, flags);
    }

    public static class Builder {
        private String tr;
        private String ts;
        private long pe = 0L;
        private long qU = 0L;
        private List<DataType> rh = new ArrayList<DataType>();
        private List<DataSource> sO = new ArrayList<DataSource>();
        private boolean tt = false;
        private boolean sZ = false;
        private List<String> tu = new ArrayList<String>();

        public Builder setTimeInterval(long startTimeMillis, long endTimeMillis) {
            this.pe = startTimeMillis;
            this.qU = endTimeMillis;
            return this;
        }

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            return this.setTimeInterval(timeUnit.toMillis(startTime), timeUnit.toMillis(endTime));
        }

        public Builder setSessionName(String sessionName) {
            this.tr = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.ts = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            l.a(dataSource, (Object)"Attempting to add a null data source");
            if (!this.sO.contains(dataSource)) {
                this.sO.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            l.a(dataType, (Object)"Attempting to use a null data type");
            if (!this.rh.contains(dataType)) {
                this.rh.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.tt = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            l.a(appPackageName, (Object)"Attempting to use a null package name");
            if (!this.tu.contains(appPackageName)) {
                this.tu.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.sZ = true;
            return this;
        }

        public SessionReadRequest build() {
            l.b(this.pe > 0L, "Invalid start time: %s", this.pe);
            l.b(this.qU > 0L && this.qU > this.pe, "Invalid end time: %s", this.qU);
            return new SessionReadRequest(this);
        }
    }
}

