/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.h;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int nS;
    private final String mName;
    private final List<Field> rB;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new h();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields) {
        this.nS = versionCode;
        this.mName = name;
        this.rB = Collections.unmodifiableList(fields);
    }

    private DataTypeCreateRequest(Builder builder) {
        this.nS = 1;
        this.mName = builder.mName;
        this.rB = Collections.unmodifiableList(builder.rB);
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.rB;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataTypeCreateRequest && this.a((DataTypeCreateRequest)o2);
    }

    private boolean a(DataTypeCreateRequest dataTypeCreateRequest) {
        return k.equal(this.mName, dataTypeCreateRequest.mName) && k.equal(this.rB, dataTypeCreateRequest.rB);
    }

    public int hashCode() {
        return k.hashCode(this.mName, this.rB);
    }

    public String toString() {
        return k.e(this).a("name", this.mName).a("fields", this.rB).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        h.a(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> rB = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.rB.contains(field)) {
                this.rB.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            l.b(name != null || !name.isEmpty(), (Object)"Invalid name specified");
            Field field = new Field(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            l.a(this.mName != null, (Object)"Must set the name");
            l.a(!this.rB.isEmpty(), (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

