/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.AggregateDataTypes;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.DataTypes;
import com.google.android.gms.fitness.request.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    private final int nS;
    private final List<DataType> rh;
    private final List<DataSource> sO;
    private final long pe;
    private final long qU;
    private final List<DataType> sS;
    private final List<DataSource> sT;
    private final int rk;
    private final long sU;
    private final DataSource sV;
    private final int sW;
    private final boolean sX;
    private final boolean sY;
    private final boolean sZ;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new f();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean disableTransformations, boolean flushBeforeRead, boolean serverQueriesEnabled) {
        this.nS = versionCode;
        this.rh = Collections.unmodifiableList(dataTypes);
        this.sO = Collections.unmodifiableList(dataSources);
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.sS = Collections.unmodifiableList(aggregatedDataTypes);
        this.sT = Collections.unmodifiableList(aggregatedDataSources);
        this.rk = bucketType;
        this.sU = bucketDurationMillis;
        this.sV = activityDataSource;
        this.sW = limit;
        this.sX = disableTransformations;
        this.sY = flushBeforeRead;
        this.sZ = serverQueriesEnabled;
    }

    private DataReadRequest(Builder builder) {
        this.nS = 2;
        this.rh = Collections.unmodifiableList(builder.rh);
        this.sO = Collections.unmodifiableList(builder.sO);
        this.pe = builder.pe;
        this.qU = builder.qU;
        this.sS = Collections.unmodifiableList(builder.sS);
        this.sT = Collections.unmodifiableList(builder.sT);
        this.rk = builder.rk;
        this.sU = builder.sU;
        this.sV = builder.sV;
        this.sW = builder.sW;
        this.sX = builder.sX;
        this.sY = builder.sY;
        this.sZ = builder.sZ;
    }

    public List<DataType> getDataTypes() {
        return this.rh;
    }

    public List<DataSource> getDataSources() {
        return this.sO;
    }

    public long getStartTimeMillis() {
        return this.pe;
    }

    public long getEndTimeMillis() {
        return this.qU;
    }

    public List<DataType> cC() {
        return this.sS;
    }

    public List<DataSource> cD() {
        return this.sT;
    }

    public int getBucketType() {
        return this.rk;
    }

    public long cE() {
        return this.sU;
    }

    public DataSource cF() {
        return this.sV;
    }

    public int cG() {
        return this.sW;
    }

    public boolean cH() {
        return this.sX;
    }

    public boolean cI() {
        return this.sZ;
    }

    public boolean cJ() {
        return this.sY;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.a((DataReadRequest)that);
    }

    private boolean a(DataReadRequest dataReadRequest) {
        return this.rh.equals(dataReadRequest.rh) && this.sO.equals(dataReadRequest.sO) && this.pe == dataReadRequest.pe && this.qU == dataReadRequest.qU && this.rk == dataReadRequest.rk && this.sT.equals(dataReadRequest.sT) && this.sS.equals(dataReadRequest.sS) && k.equal(this.sV, dataReadRequest.sV) && this.sU == dataReadRequest.sU && this.sZ == dataReadRequest.sZ;
    }

    public int hashCode() {
        return k.hashCode(this.rk, this.pe, this.qU);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReadDataRequest{");
        if (!this.rh.isEmpty()) {
            for (DataType safeParcelable : this.rh) {
                stringBuilder.append(safeParcelable.cn()).append(" ");
            }
        }
        if (!this.sO.isEmpty()) {
            for (DataSource dataSource : this.sO) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.rk != 0) {
            stringBuilder.append("bucket by ").append(Bucket.N(this.rk));
            if (this.sU > 0L) {
                stringBuilder.append(" >").append(this.sU).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.sS.isEmpty()) {
            for (DataType dataType : this.sS) {
                stringBuilder.append(dataType.cn()).append(" ");
            }
        }
        if (!this.sT.isEmpty()) {
            for (DataSource dataSource : this.sT) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.pe, this.pe, this.qU, this.qU));
        if (this.sV != null) {
            stringBuilder.append("activities: ").append(this.sV.toDebugString());
        }
        if (this.sZ) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> rh = new ArrayList<DataType>();
        private List<DataSource> sO = new ArrayList<DataSource>();
        private List<DataType> sS = new ArrayList<DataType>();
        private List<DataSource> sT = new ArrayList<DataSource>();
        private DataSource sV;
        private long pe;
        private long qU;
        private int rk = 0;
        private long sU = 0L;
        private int sW = 0;
        private boolean sX = false;
        private boolean sY = false;
        private boolean sZ = false;

        public Builder read(DataSource dataSource) {
            l.a(dataSource, (Object)"Attempting to add a null data source");
            l.b(!this.sT.contains(dataSource), (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.sO.contains(dataSource)) {
                this.sO.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            l.a(dataType, (Object)"Attempting to use a null data type");
            l.a(!this.sS.contains(dataType), (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.rh.contains(dataType)) {
                this.rh.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            l.a(dataSource, (Object)"Attempting to add a null data source");
            l.a(!this.sO.contains(dataSource), (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            l.b(AggregateDataTypes.INPUT_TYPES.contains(dataType), "Unsupported input data type specified for aggregation: %s", dataType);
            l.b(AggregateDataTypes.getForInput(dataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", dataType, outputDataType);
            if (!this.sT.contains(dataSource)) {
                this.sT.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            l.a(inputDataType, (Object)"Attempting to use a null data type");
            l.a(!this.rh.contains(inputDataType), (Object)"Cannot add the same data type as aggregated and detailed");
            l.b(AggregateDataTypes.INPUT_TYPES.contains(inputDataType), "Unsupported input data type specified for aggregation: %s", inputDataType);
            l.b(AggregateDataTypes.getForInput(inputDataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", inputDataType, outputDataType);
            if (!this.sS.contains(inputDataType)) {
                this.sS.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(duration > 0, "Must specify a valid minimum duration for an activity segment: %d", duration);
            this.rk = 1;
            this.sU = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rk = 3;
            this.sU = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            l.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            l.b(activityDataSource.getDataType().equals(DataTypes.ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.sV = activityDataSource;
            this.rk = 3;
            this.sU = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rk = 4;
            this.sU = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            l.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            l.b(activityDataSource.getDataType().equals(DataTypes.ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.sV = activityDataSource;
            this.rk = 4;
            this.sU = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            l.b(this.rk == 0, "Bucketing strategy already set to %s", this.rk);
            l.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rk = 2;
            this.sU = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long startTimeMillis, long endTimeMillis) {
            this.pe = startTimeMillis;
            this.qU = endTimeMillis;
            return this;
        }

        public Builder enableServerQueries() {
            this.sZ = true;
            return this;
        }

        public DataReadRequest build() {
            l.a(!this.sO.isEmpty() || !this.rh.isEmpty() || !this.sT.isEmpty() || !this.sS.isEmpty(), (Object)"Must add at least one data source (aggregated or detailed)");
            l.a(this.pe > 0L, "Invalid start time: %s", this.pe);
            l.a(this.qU > 0L && this.qU > this.pe, "Invalid end time: %s", this.qU);
            boolean bl2 = this.sT.isEmpty() && this.sS.isEmpty();
            l.a(bl2 && this.rk == 0 || !bl2 && this.rk != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

