/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.u;

public final class Value
implements SafeParcelable {
    private final int nS;
    private final int rH;
    private boolean rY;
    private float rZ;
    public static final Parcelable.Creator<Value> CREATOR = new u();

    Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.nS = versionCode;
        this.rH = format;
        this.rY = isSet;
        this.rZ = value;
    }

    public void setInt(int value) {
        l.a(this.rH == 1, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.rY = true;
        this.rZ = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        l.a(this.rH == 2, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.rY = true;
        this.rZ = value;
    }

    public boolean isSet() {
        return this.rY;
    }

    public int getFormat() {
        return this.rH;
    }

    public int asInt() {
        l.a(this.rH == 1, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.rZ);
    }

    public float asFloat() {
        l.a(this.rH == 2, (Object)"Value is not in float format");
        return this.rZ;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Value && this.a((Value)o2);
    }

    private boolean a(Value value) {
        if (this.rH == value.rH && this.rY == value.rY) {
            switch (this.rH) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.rZ == value.rZ;
        }
        return false;
    }

    public int hashCode() {
        return k.hashCode(Float.valueOf(this.rZ), this.rH, this.rY);
    }

    public String toString() {
        switch (this.rH) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.nS;
    }

    float cu() {
        return this.rZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        u.a(this, dest, flags);
    }
}

