/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.p;

public class Session
implements SafeParcelable {
    private final int nS;
    private final long pe;
    private final long qU;
    private final String mName;
    private final String rT;
    private final String rU;
    private final int ri;
    private final a rx;
    public static final Parcelable.Creator<Session> CREATOR = new p();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activity, a application) {
        this.nS = versionCode;
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.mName = name;
        this.rT = identifier;
        this.rU = description;
        this.ri = activity;
        this.rx = application;
    }

    private Session(Builder builder) {
        this.nS = 2;
        this.pe = builder.pe;
        this.qU = builder.qU;
        this.mName = builder.mName;
        this.rT = builder.rT;
        this.rU = builder.rU;
        this.ri = builder.ri;
        this.rx = builder.rx;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "vnd.google.fitness.session", CREATOR);
    }

    public long getStartTimeMillis() {
        return this.pe;
    }

    public long getEndTimeMillis() {
        return this.qU;
    }

    public boolean isOngoing() {
        return this.qU == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.rT;
    }

    public String getDescription() {
        return this.rU;
    }

    public int getActivity() {
        return this.ri;
    }

    public a cj() {
        return this.rx;
    }

    public String getAppPackageName() {
        return this.rx == null ? null : this.rx.getPackageName();
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Session && this.a((Session)o2);
    }

    private boolean a(Session session) {
        return this.pe == session.pe && this.qU == session.qU && k.equal(this.mName, session.mName) && k.equal(this.rT, session.rT) && k.equal(this.rU, session.rU) && k.equal(this.rx, session.rx) && this.ri == session.ri;
    }

    public int hashCode() {
        return k.hashCode(this.pe, this.qU, this.mName, this.rT, this.ri, this.rx, this.rU);
    }

    public String toString() {
        return k.e(this).a("startTime", this.pe).a("endTime", this.qU).a("name", this.mName).a("identifier", this.rT).a("description", this.rU).a("activity", this.ri).a("application", this.rx).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        p.a(this, dest, flags);
    }

    public static class Builder {
        private long pe = 0L;
        private long qU = 0L;
        private String mName = null;
        private String rT;
        private String rU;
        private int ri = 4;
        private a rx;

        public Builder setStartTimeMillis(long startTimeMillis) {
            l.a(startTimeMillis > 0L, (Object)"Start time should be positive.");
            this.pe = startTimeMillis;
            return this;
        }

        public Builder setEndTimeMillis(long endTimeMillis) {
            l.a(endTimeMillis >= 0L, (Object)"End time should be positive.");
            this.qU = endTimeMillis;
            return this;
        }

        public Builder setName(String name) {
            l.b(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.rT = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            l.b(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.rU = description;
            return this;
        }

        public Builder setActivity(int activity) {
            this.ri = FitnessActivities.K(activity);
            return this;
        }

        public Session build() {
            l.a(this.pe > 0L, (Object)"Start time should be specified.");
            l.a(this.qU == 0L || this.qU > this.pe, (Object)"End time should be later than start time.");
            if (this.rT == null) {
                this.rT = (this.mName == null ? "" : this.mName) + this.pe;
            }
            return new Session(this);
        }
    }
}

