/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.i;
import com.google.android.gms.internal.ai;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int nS;
    private final String rE;
    private final String rF;
    private final String rd;
    private final String rG;
    private final int rv;
    public static final Parcelable.Creator<Device> CREATOR = new i();

    public static Device getLocalDevice(Context context) {
        int n2 = Device.q(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, Build.SERIAL, n2);
    }

    private static int q(Context context) {
        switch (Device.s(context)) {
            case 10: {
                return Device.r(context) ? 3 : 0;
            }
            case 8: 
            case 9: {
                return 0;
            }
        }
        return Device.u(context) ? 1 : 2;
    }

    public static boolean r(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return (configuration.uiMode & 0xF) == 6;
    }

    private static int s(Context context) {
        return Device.t(context) % 1000 / 100 + 5;
    }

    private static int t(Context context) {
        try {
            String string2 = "com.google.android.gms";
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"Fitness", (String)"Could not find package info for Google Play Services");
            return -1;
        }
    }

    private static boolean u(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(1, manufacturer, model, "", uid, type);
    }

    public Device(String manufacturer, String model, String version, String uid, int type) {
        this(manufacturer, model, uid, type);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type) {
        this.nS = versionCode;
        this.rE = l.f(manufacturer);
        this.rF = l.f(model);
        this.rd = "";
        this.rG = l.f(uid);
        this.rv = type;
    }

    public String getManufacturer() {
        return this.rE;
    }

    public String getModel() {
        return this.rF;
    }

    public String getVersion() {
        return this.rd;
    }

    public String getUid() {
        return this.rG;
    }

    public int getType() {
        return this.rv;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.rE, this.rF, this.rG);
    }

    Device co() {
        return new Device(ai.H(this.rE), ai.H(this.rF), ai.H(this.rd), this.rG, this.rv);
    }

    public String cp() {
        return ai.cw() ? this.rG : ai.H(this.rG);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s}", this.getStreamIdentifier(), this.rd, this.rv);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.a((Device)that);
    }

    private boolean a(Device device) {
        return k.equal(this.rE, device.rE) && k.equal(this.rF, device.rF) && k.equal(this.rd, device.rd) && k.equal(this.rG, device.rG) && this.rv == device.rv;
    }

    public int hashCode() {
        return k.hashCode(this.rE, this.rF, this.rd, this.rG, this.rv);
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        i.a(this, parcel, flags);
    }
}

