/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int nS;
    private final DataSource qT;
    private final DataType rs;
    private final List<DataPoint> rt;
    private final List<DataSource> ru;
    private boolean rl = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new f();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.nS = versionCode;
        this.qT = dataSource;
        this.rs = dataType;
        this.rl = serverHasMoreData;
        this.rt = new ArrayList<DataPoint>(dataPoints.size());
        this.ru = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.rt.add(new DataPoint(this.ru, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource, DataType dataType) {
        this.nS = 3;
        this.qT = l.f(dataSource);
        this.rs = l.f(dataType);
        this.rt = new ArrayList<DataPoint>();
        this.ru = new ArrayList<DataSource>();
        this.ru.add(this.qT);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(3, DataSet.b(uniqueDataSources, dataSet.rP), DataSet.b(uniqueDataTypes, dataSet.rR), dataSet.rS, uniqueDataSources, dataSet.rl);
    }

    private static <T> T b(List<T> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? (T)list.get(n2) : null;
    }

    public static DataSet create(DataSource dataSource) {
        return new DataSet(dataSource, dataSource.getDataType());
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.qT);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        l.b(dataSource.getStreamIdentifier().equals(this.qT.getStreamIdentifier()), "Conflicting data sources found %s vs %s", dataSource, this.qT);
        l.b(dataPoint.getDataType().getName().equals(this.rs.getName()), "Conflicting data types found %s vs %s", dataPoint.getDataType(), this.rs);
        l.b(dataPoint.getTimestampNanos() > 0L, "Data point does not have the timestamp set: %s", dataPoint);
        l.b(dataPoint.getStartTimeNanos() <= dataPoint.getEndTimeNanos(), "Data point with start time greater than end time found: %s", dataPoint);
        this.b(dataPoint);
    }

    public void b(DataPoint dataPoint) {
        this.rt.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.ru.contains(dataSource)) {
            this.ru.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void a(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.b(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.qT;
    }

    public DataType getDataType() {
        return this.rs;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.rt);
    }

    public boolean cd() {
        return this.rl;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataSet && this.a((DataSet)o2);
    }

    private boolean a(DataSet dataSet) {
        return k.equal(this.rs, dataSet.rs) && k.equal(this.qT, dataSet.qT) && k.equal(this.rt, dataSet.rt) && this.rl == dataSet.rl;
    }

    public int hashCode() {
        return k.hashCode(this.rs, this.qT);
    }

    public String toString() {
        List<RawDataPoint> list = this.ch();
        return String.format("DataSet{%s %s}", this.qT.toDebugString(), this.rt.size() < 10 ? list : String.format("%d data points, first 5: %s", this.rt.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.nS;
    }

    List<RawDataPoint> ch() {
        return this.b(this.ru);
    }

    List<RawDataPoint> b(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.rt.size());
        for (DataPoint dataPoint : this.rt) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> ci() {
        return this.ru;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        f.a(this, parcel, flags);
    }
}

