/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.d;
import java.util.ArrayList;
import java.util.List;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int nS;
    private final long pe;
    private final long qU;
    private final Session qW;
    private final int ri;
    private final List<DataSet> rj;
    private final int rk;
    private boolean rl = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new d();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.nS = versionCode;
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.qW = session;
        this.ri = activity;
        this.rj = dataSets;
        this.rk = bucketType;
        this.rl = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(2, bucket.pe, bucket.qU, bucket.qW, bucket.ri, Bucket.a(bucket.rj, uniqueDataSources, uniqueDataTypes), bucket.rk, bucket.rl);
    }

    private static List<DataSet> a(List<RawDataSet> list, List<DataSource> list2, List<DataType> list3) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(list.size());
        for (RawDataSet rawDataSet : list) {
            arrayList.add(new DataSet(rawDataSet, list2, list3));
        }
        return arrayList;
    }

    public long getStartTimeMillis() {
        return this.pe;
    }

    public long getEndTimeMillis() {
        return this.qU;
    }

    public Session getSession() {
        return this.qW;
    }

    public int getActivity() {
        return this.ri;
    }

    public List<DataSet> getDataSets() {
        return this.rj;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.rj) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.rk;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Bucket && this.a((Bucket)o2);
    }

    private boolean a(Bucket bucket) {
        return this.pe == bucket.pe && this.qU == bucket.qU && this.ri == bucket.ri && k.equal(this.rj, bucket.rj) && this.rk == bucket.rk && this.rl == bucket.rl;
    }

    public boolean b(Bucket bucket) {
        return this.pe == bucket.pe && this.qU == bucket.qU && this.ri == bucket.ri && this.rk == bucket.rk;
    }

    public boolean cd() {
        if (this.rl) {
            return true;
        }
        for (DataSet dataSet : this.rj) {
            if (!dataSet.cd()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return k.hashCode(this.pe, this.qU, this.ri, this.rk);
    }

    public String toString() {
        return k.e(this).a("startTime", this.pe).a("endTime", this.qU).a("activity", this.ri).a("dataSets", this.rj).a("bucketType", Bucket.N(this.rk)).a("serverHasMoreData", this.rl).toString();
    }

    public static String N(int n2) {
        switch (n2) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }
}

