/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Parcel;
import android.view.View;
import com.google.android.gms.common.internal.ParcelableClientSettingsCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ClientSettings {
    private final ParcelableClientSettings pD;
    private final View nh;

    public ClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, View viewForPopups, String realClientPackageName) {
        this.pD = new ParcelableClientSettings(accountName, scopes, gravityForPopups, realClientPackageName);
        this.nh = viewForPopups;
    }

    public String getAccountName() {
        return this.pD.getAccountName();
    }

    public String getAccountNameOrDefault() {
        return this.pD.getAccountNameOrDefault();
    }

    public int getGravityForPopups() {
        return this.pD.getGravityForPopups();
    }

    public List<String> getScopes() {
        return this.pD.getScopes();
    }

    public String[] getScopesArray() {
        return this.pD.getScopes().toArray(new String[0]);
    }

    public String getRealClientPackageName() {
        return this.pD.getRealClientPackageName();
    }

    public View getViewForPopups() {
        return this.nh;
    }

    public ParcelableClientSettings getParcelableClientSettings() {
        return this.pD;
    }

    public static final class ParcelableClientSettings
    implements SafeParcelable {
        public static final ParcelableClientSettingsCreator CREATOR = new ParcelableClientSettingsCreator();
        private final int nS;
        private final String kK;
        private final List<String> nE = new ArrayList<String>();
        private final int ng;
        private final String ni;

        ParcelableClientSettings(int versionCode, String accountName, List<String> scopes, int gravityForPopups, String realClientPackageName) {
            this.nS = versionCode;
            this.kK = accountName;
            this.nE.addAll(scopes);
            this.ng = gravityForPopups;
            this.ni = realClientPackageName;
        }

        public ParcelableClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, String realClientPackageName) {
            this(3, accountName, new ArrayList<String>(scopes), gravityForPopups, realClientPackageName);
        }

        public String getAccountName() {
            return this.kK;
        }

        public String getAccountNameOrDefault() {
            return this.kK != null ? this.kK : "<<default account>>";
        }

        public int getGravityForPopups() {
            return this.ng;
        }

        public String getRealClientPackageName() {
            return this.ni;
        }

        public List<String> getScopes() {
            return new ArrayList<String>(this.nE);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            ParcelableClientSettingsCreator.a(this, out, flags);
        }

        public int getVersionCode() {
            return this.nS;
        }
    }
}

