/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.n;
import com.google.android.gms.internal.o;
import com.google.android.gms.internal.u;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object oC = new Object();
    private static HashSet<Uri> oD = new HashSet();
    private static ImageManager oE;
    private static ImageManager oF;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService oG;
    private final b oH;
    private final n oI;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> oJ;
    private final Map<Uri, ImageReceiver> oK;
    private final Map<Uri, Long> oL;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (oF == null) {
                oF = new ImageManager(context, true);
            }
            return oF;
        }
        if (oE == null) {
            oE = new ImageManager(context, false);
        }
        return oE;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.oG = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.oH = new b(this.mContext);
            if (u.bW()) {
                this.bD();
            }
        } else {
            this.oH = null;
        }
        this.oI = new n();
        this.oJ = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.oK = new HashMap<Uri, ImageReceiver>();
        this.oL = new HashMap<Uri, Long>();
    }

    private void bD() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.oH));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        a.b b2 = new a.b(imageView, uri);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, int resId) {
        a.b b2 = new a.b(imageView, resId);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        a.b b2 = new a.b(imageView, uri);
        b2.z(defaultResId);
        this.a(b2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        a.c c2 = new a.c(listener, uri);
        this.a(c2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        a.c c2 = new a.c(listener, uri);
        c2.z(defaultResId);
        this.a(c2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        com.google.android.gms.common.internal.a.A("ImageManager.loadImage() must be called in the main thread");
        d d2 = new d(a2);
        d2.run();
    }

    private Bitmap a(a.a a2) {
        if (this.oH == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.oH.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class b
    extends o<a.a, Bitmap> {
        public b(Context context) {
            super(b.m(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int m(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && u.bU() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b oH;

        public e(b b2) {
            this.oH = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.oH.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.oH.evictAll();
            } else if (level >= 20) {
                this.oH.trimToSize(this.oH.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch mO;
        private boolean oQ;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.oQ = bl2;
            this.mO = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            com.google.android.gms.common.internal.a.A("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.oH != null) {
                if (this.oQ) {
                    ImageManager.this.oH.evictAll();
                    System.gc();
                    this.oQ = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.oH.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.oK.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.mO.countDown();
            Object object = oC;
            synchronized (object) {
                oD.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            ArrayList arrayList = imageReceiver.oM;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.oL.put(this.mUri, SystemClock.elapsedRealtime());
                    a2.a(ImageManager.this.mContext, ImageManager.this.oI, false);
                }
                if (a2 instanceof a.c) continue;
                ImageManager.this.oJ.remove(a2);
            }
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor oO;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.oO = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.a.B("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.oO != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.oO.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.oO.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> oM;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.oM = new ArrayList();
        }

        public void b(com.google.android.gms.common.images.a a2) {
            com.google.android.gms.common.internal.a.A("ImageReceiver.addImageRequest() must be called in the main thread");
            this.oM.add(a2);
        }

        public void c(com.google.android.gms.common.images.a a2) {
            com.google.android.gms.common.internal.a.A("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.oM.remove(a2);
        }

        public void bG() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.oG.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a oP;

        public d(com.google.android.gms.common.images.a a2) {
            this.oP = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.a.A("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.oJ.get(this.oP));
            if (imageReceiver != null) {
                ImageManager.this.oJ.remove(this.oP);
                imageReceiver.c(this.oP);
            }
            a.a a2 = this.oP.oR;
            if (a2.uri == null) {
                this.oP.a(ImageManager.this.mContext, ImageManager.this.oI, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.oP.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l2 = (Long)ImageManager.this.oL.get(a2.uri);
            if (l2 != null) {
                if (SystemClock.elapsedRealtime() - l2 < 3600000L) {
                    this.oP.a(ImageManager.this.mContext, ImageManager.this.oI, true);
                    return;
                }
                ImageManager.this.oL.remove(a2.uri);
            }
            this.oP.a(ImageManager.this.mContext, ImageManager.this.oI);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.oK.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.oK.put(a2.uri, imageReceiver);
            }
            imageReceiver.b(this.oP);
            if (!(this.oP instanceof a.c)) {
                ImageManager.this.oJ.put(this.oP, imageReceiver);
            }
            Object object = oC;
            synchronized (object) {
                boolean bl2 = oD.contains(a2.uri);
                if (!bl2) {
                    oD.add(a2.uri);
                    imageReceiver.bG();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

