/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.l;

public class c
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean nU;
    private int nV = -1;
    private ConnectionResult nW;
    private final Handler nX = new Handler(Looper.getMainLooper());
    private final SparseArray<b> nY = new SparseArray();

    public static c a(FragmentActivity fragmentActivity) {
        c c2;
        l.A("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            c2 = (c)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (c2 == null || c2.isRemoving()) {
            c2 = new c();
            fragmentManager.beginTransaction().add((Fragment)c2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return c2;
    }

    public GoogleApiClient p(int n2) {
        a a2;
        if (this.getActivity() != null && (a2 = this.r(n2)) != null) {
            return a2.nZ;
        }
        return null;
    }

    public void a(int n2, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        l.a(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        l.a(this.nY.indexOfKey(n2) < 0, (Object)("Already managing a GoogleApiClient with id " + n2));
        b b2 = new b(googleApiClient, onConnectionFailedListener);
        this.nY.put(n2, (Object)b2);
        if (this.getActivity() != null) {
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void q(int n2) {
        this.getLoaderManager().destroyLoader(n2);
        this.nY.remove(n2);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.b(this.nV, this.nW);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i2 = 0; i2 < this.nY.size(); ++i2) {
            int n2 = this.nY.keyAt(i2);
            a a2 = this.r(n2);
            if (a2 != null) {
                b b2 = (b)this.nY.valueAt(i2);
                if (b2.nZ != a2.nZ) {
                    this.getLoaderManager().restartLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.nU = savedInstanceState.getBoolean("resolving_error", false);
            this.nV = savedInstanceState.getInt("failed_client_id", -1);
            if (this.nV >= 0) {
                this.nW = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.nU);
        if (this.nV >= 0) {
            outState.putInt("failed_client_id", this.nV);
            outState.putInt("failed_status", this.nW.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.nW.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.nU) {
            for (int i2 = 0; i2 < this.nY.size(); ++i2) {
                this.getLoaderManager().initLoader(this.nY.keyAt(i2), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl2 = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl2 = true;
            }
        }
        if (bl2) {
            this.bu();
        } else {
            this.b(this.nV, this.nW);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new a((Context)this.getActivity(), ((b)this.nY.get((int)id)).nZ);
    }

    public void a(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.s(loader.getId());
        } else {
            this.a(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
        if (loader.getId() == this.nV) {
            this.bu();
        }
    }

    a r(int n2) {
        try {
            return (a)this.getLoaderManager().getLoader(n2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void s(int n2) {
        if (n2 == this.nV) {
            this.bu();
        }
    }

    private void a(int n2, ConnectionResult connectionResult) {
        if (!this.nU) {
            this.nU = true;
            this.nV = n2;
            this.nW = connectionResult;
            this.nX.post((Runnable)new c(n2, connectionResult));
        }
    }

    private void b(int n2, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        b b2 = (b)this.nY.get(n2);
        if (b2 != null) {
            this.q(n2);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = b2.oc;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.bu();
    }

    private void bu() {
        this.nU = false;
        this.nV = -1;
        this.nW = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i2 = 0; i2 < this.nY.size(); ++i2) {
            int n2 = this.nY.keyAt(i2);
            a a2 = this.r(n2);
            if (a2 != null) {
                a2.bv();
            }
            loaderManager.initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.a((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class a
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient nZ;
        private boolean oa;
        private ConnectionResult ob;

        public a(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.nZ = googleApiClient;
        }

        public void bv() {
            if (this.oa) {
                this.oa = false;
                if (this.isStarted() && !this.isAbandoned()) {
                    this.nZ.connect();
                }
            }
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.nZ.registerConnectionCallbacks(this);
            this.nZ.registerConnectionFailedListener(this);
            if (this.ob != null) {
                this.deliverResult(this.ob);
            }
            if (!(this.nZ.isConnected() || this.nZ.isConnecting() || this.oa)) {
                this.nZ.connect();
            }
        }

        protected void onStopLoading() {
            this.nZ.disconnect();
        }

        protected void onReset() {
            this.ob = null;
            this.oa = false;
            this.nZ.unregisterConnectionCallbacks(this);
            this.nZ.unregisterConnectionFailedListener(this);
            this.nZ.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.oa = false;
            this.a(ConnectionResult.mf);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.oa = true;
            this.a(result);
        }

        private void a(ConnectionResult connectionResult) {
            this.ob = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class b {
        public final GoogleApiClient nZ;
        public final GoogleApiClient.OnConnectionFailedListener oc;

        private b(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.nZ = googleApiClient;
            this.oc = onConnectionFailedListener;
        }
    }

    private class c
    implements Runnable {
        private final int od;
        private final ConnectionResult oe;

        public c(int n2, ConnectionResult connectionResult) {
            this.od = n2;
            this.oe = connectionResult;
        }

        @Override
        public void run() {
            if (this.oe.hasResolution()) {
                try {
                    int n2 = c.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)c.this);
                    int n3 = 1 + (1 + n2 << 16);
                    this.oe.startResolutionForResult((Activity)c.this.getActivity(), n3);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    c.this.bu();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.oe.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.oe.getErrorCode(), (Activity)c.this.getActivity(), c.this, 2, c.this);
            } else {
                c.this.b(this.od, this.oe);
            }
        }
    }
}

