/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.c;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.l;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T var1);

    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String kK;
        private final Set<String> nf = new HashSet<String>();
        private int ng;
        private View nh;
        private String ni;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> nj = new HashMap();
        private FragmentActivity nk;
        private int nl = -1;
        private OnConnectionFailedListener nm;
        private Looper ne;
        private final Set<ConnectionCallbacks> nn = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> no = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.ne = context.getMainLooper();
            this.ni = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            l.a(connectedListener, (Object)"Must provide a connected listener");
            this.nn.add(connectedListener);
            l.a(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.no.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            l.a(handler, (Object)"Handler must not be null");
            this.ne = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.nn.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.no.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.nh = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.nf.add(scope.bt());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.nj.put(api, null);
            List<Scope> list = api.be();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.nf.add(list.get(i2).bt());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            l.a(options, (Object)"Null options are not permitted for this Api");
            this.nj.put(api, options);
            List<Scope> list = api.be();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.nf.add(list.get(i2).bt());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.kK = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.ng = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            l.b(clientId >= 0, (Object)"clientId must be non-negative");
            this.nl = clientId;
            this.nk = l.a(fragmentActivity, (Object)"Null activity is not permitted.");
            this.nm = unresolvedConnectionFailedListener;
            return this;
        }

        public ClientSettings bl() {
            return new ClientSettings(this.kK, this.nf, this.ng, this.nh, this.ni);
        }

        public GoogleApiClient build() {
            l.b(!this.nj.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.nl >= 0) {
                return this.bm();
            }
            return new a(this.mContext, this.ne, this.bl(), this.nj, this.nn, this.no, -1);
        }

        private GoogleApiClient bm() {
            c c2 = c.a(this.nk);
            GoogleApiClient googleApiClient = c2.p(this.nl);
            if (googleApiClient == null) {
                googleApiClient = new a(this.mContext.getApplicationContext(), this.ne, this.bl(), this.nj, this.nn, this.no, this.nl);
            }
            c2.a(this.nl, googleApiClient, this.nm);
            return googleApiClient;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

