/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.dynamic.e;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View mI;
    private View.OnClickListener mJ = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        l.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        l.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.l(this.getContext());
    }

    private void l(Context context) {
        if (this.mI != null) {
            this.removeView(this.mI);
        }
        try {
            this.mI = m.b(context, this.mSize, this.mColor);
        }
        catch (e.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.mI = SignInButton.a(context, this.mSize, this.mColor);
        }
        this.addView(this.mI);
        this.mI.setEnabled(this.isEnabled());
        this.mI.setOnClickListener((View.OnClickListener)this);
    }

    private static Button a(Context context, int n2, int n3) {
        n n4 = new n(context);
        n4.a(context.getResources(), n2, n3);
        return n4;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mJ = listener;
        if (this.mI != null) {
            this.mI.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mI.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.mJ != null && view == this.mI) {
            this.mJ.onClick((View)this);
        }
    }
}

