/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.q;
import com.google.android.gms.internal.w;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.ab;
import com.google.android.gms.wearable.internal.ac;
import com.google.android.gms.wearable.internal.ad;
import com.google.android.gms.wearable.internal.ae;
import com.google.android.gms.wearable.internal.ah;
import com.google.android.gms.wearable.internal.am;
import com.google.android.gms.wearable.internal.ao;
import com.google.android.gms.wearable.internal.aq;
import com.google.android.gms.wearable.internal.av;
import com.google.android.gms.wearable.internal.b;
import com.google.android.gms.wearable.internal.f;
import com.google.android.gms.wearable.internal.p;
import com.google.android.gms.wearable.internal.t;
import com.google.android.gms.wearable.internal.v;
import com.google.android.gms.wearable.internal.x;
import com.google.android.gms.wearable.internal.z;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class au
extends q<ad> {
    private final ExecutorService yO = Executors.newCachedThreadPool();
    private final HashMap<DataApi.DataListener, av> BI = new HashMap();
    private final HashMap<MessageApi.MessageListener, av> BJ = new HashMap();
    private final HashMap<NodeApi.NodeListener, av> BK = new HashMap();

    public au(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, new String[0]);
    }

    @Override
    protected String bM() {
        return "com.google.android.gms.wearable.BIND";
    }

    @Override
    protected String bN() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected ad af(IBinder iBinder) {
        return ad.a.ae(iBinder);
    }

    @Override
    protected void a(w w2, q.d d2) throws RemoteException {
        w2.e(d2, 5077500, this.getContext().getPackageName());
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n2));
        }
        if (n2 == 0) {
            try {
                com.google.android.gms.wearable.internal.a a2 = new com.google.android.gms.wearable.internal.a(){

                    @Override
                    public void f(Status status) {
                    }
                };
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.d((String)"WearableClient", (String)("onPostInitHandler: service " + iBinder));
                }
                ad ad2 = ad.a.ae(iBinder);
                for (Map.Entry<DataApi.DataListener, av> entry : this.BI.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Data listener " + entry.getValue()));
                    }
                    ad2.a((ab)a2, new b(entry.getValue()));
                }
                for (Map.Entry<Object, av> entry : this.BJ.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Message listener " + entry.getValue()));
                    }
                    ad2.a((ab)a2, new b(entry.getValue()));
                }
                for (Map.Entry<Object, av> entry : this.BK.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Node listener " + entry.getValue()));
                    }
                    ad2.a((ab)a2, new b(entry.getValue()));
                }
            }
            catch (RemoteException remoteException) {
                Log.d((String)"WearableClient", (String)"WearableClientImpl.onPostInitHandler: error while adding listener", (Throwable)remoteException);
            }
        }
        Log.d((String)"WearableClient", (String)"WearableClientImpl.onPostInitHandler: done");
        super.a(n2, iBinder, bundle);
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.BI.clear();
        this.BJ.clear();
        this.BK.clear();
    }

    public void a(a.d<DataApi.DataItemResult> d2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.d(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            ParcelFileDescriptor[] parcelFileDescriptorArray;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() == null) {
                putDataRequest2.putAsset((String)entry3.getKey(), (Asset)entry3.getValue());
                continue;
            }
            try {
                parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
            }
            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptorArray[0] + " write:" + parcelFileDescriptorArray[1]));
            }
            putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
            FutureTask<Boolean> futureTask = this.a(parcelFileDescriptorArray[1], asset.getData());
            entry22.add(futureTask);
            this.yO.submit(futureTask);
        }
        try {
            ((ad)this.bO()).a((ab)new a(d2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Unable to putDataItem: " + putDataRequest, nullPointerException);
        }
    }

    private FutureTask<Boolean> a(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean fl() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.fl();
            }
        });
    }

    public void a(final a.d<DataApi.DataItemResult> d2, Uri uri) throws RemoteException {
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(v v2) {
                d2.a(new f.a(new Status(v2.statusCode), v2.Bp));
            }
        }, uri);
    }

    @Override
    public void a(final a.d<DataItemBuffer> d2) throws RemoteException {
        ((ad)this.bO()).d(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void e(DataHolder dataHolder) {
                d2.a(new DataItemBuffer(dataHolder));
            }
        });
    }

    public void b(final a.d<DataItemBuffer> d2, Uri uri) throws RemoteException {
        ((ad)this.bO()).b(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void e(DataHolder dataHolder) {
                d2.a(new DataItemBuffer(dataHolder));
            }
        }, uri);
    }

    public void c(final a.d<DataApi.DeleteDataItemsResult> d2, Uri uri) throws RemoteException {
        ((ad)this.bO()).c(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(p p2) {
                d2.a(new f.b(new Status(p2.statusCode), p2.Bm));
            }
        }, uri);
    }

    public void a(final a.d<MessageApi.SendMessageResult> d2, String string2, String string3, byte[] byArray) throws RemoteException {
        ((ad)this.bO()).a(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(aq aq2) {
                d2.a(new ae.a(new Status(aq2.statusCode), aq2.BG));
            }
        }, string2, string3, byArray);
    }

    public void a(final a.d<DataApi.GetFdForAssetResult> d2, Asset asset) throws RemoteException {
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(x x2) {
                d2.a(new f.c(new Status(x2.statusCode), x2.Bq));
            }
        }, asset);
    }

    public void a(a.d<DataApi.GetFdForAssetResult> d2, DataItemAsset dataItemAsset) throws RemoteException {
        this.a(d2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void b(final a.d<NodeApi.GetLocalNodeResult> d2) throws RemoteException {
        ((ad)this.bO()).e(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(z z2) {
                d2.a(new ah.b(new Status(z2.statusCode), z2.Br));
            }
        });
    }

    public void c(final a.d<NodeApi.GetConnectedNodesResult> d2) throws RemoteException {
        ((ad)this.bO()).f(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(t t2) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                arrayList.addAll(t2.Bo);
                d2.a(new ah.a(new Status(t2.statusCode), arrayList));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final a.d<Status> d2, final DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) throws RemoteException {
        av av2 = av.a(dataListener, intentFilterArray);
        HashMap<DataApi.DataListener, av> hashMap = this.BI;
        synchronized (hashMap) {
            if (this.BI.get(dataListener) != null) {
                d2.a(new Status(4001));
                return;
            }
            this.BI.put(dataListener, av2);
        }
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = au.this.BI;
                    synchronized (hashMap) {
                        au.this.BI.remove(dataListener);
                    }
                }
                d2.a(status);
            }
        }, new b(av2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final a.d<Status> d2, final MessageApi.MessageListener messageListener, IntentFilter[] intentFilterArray) throws RemoteException {
        av av2 = av.a(messageListener, intentFilterArray);
        HashMap<MessageApi.MessageListener, av> hashMap = this.BJ;
        synchronized (hashMap) {
            if (this.BJ.get(messageListener) != null) {
                d2.a(new Status(4001));
                return;
            }
            this.BJ.put(messageListener, av2);
        }
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = au.this.BJ;
                    synchronized (hashMap) {
                        au.this.BJ.remove(messageListener);
                    }
                }
                d2.a(status);
            }
        }, new b(av2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final a.d<Status> d2, final NodeApi.NodeListener nodeListener) throws RemoteException, RemoteException {
        av av2 = av.a(nodeListener);
        HashMap<NodeApi.NodeListener, av> hashMap = this.BK;
        synchronized (hashMap) {
            if (this.BK.get(nodeListener) != null) {
                d2.a(new Status(4001));
                return;
            }
            this.BK.put(nodeListener, av2);
        }
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = au.this.BK;
                    synchronized (hashMap) {
                        au.this.BK.remove(nodeListener);
                    }
                }
                d2.a(status);
            }
        }, new b(av2));
    }

    public void a(final a.d<Status> d2, ac ac2) throws RemoteException {
        ((ad)this.bO()).a((ab)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void f(Status status) {
                d2.a(status);
            }
        }, new ao(ac2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(a.d<Status> d2, DataApi.DataListener dataListener) throws RemoteException {
        ac ac2;
        HashMap<DataApi.DataListener, av> hashMap = this.BI;
        synchronized (hashMap) {
            ac2 = this.BI.remove(dataListener);
        }
        if (ac2 == null) {
            d2.a(new Status(4002));
        } else {
            this.a(d2, ac2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(a.d<Status> d2, MessageApi.MessageListener messageListener) throws RemoteException {
        HashMap<MessageApi.MessageListener, av> hashMap = this.BJ;
        synchronized (hashMap) {
            ac ac2 = this.BJ.remove(messageListener);
            if (ac2 == null) {
                d2.a(new Status(4002));
            } else {
                this.a(d2, ac2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b(a.d<Status> d2, NodeApi.NodeListener nodeListener) throws RemoteException {
        HashMap<NodeApi.NodeListener, av> hashMap = this.BK;
        synchronized (hashMap) {
            ac ac2 = this.BK.remove(nodeListener);
            if (ac2 == null) {
                d2.a(new Status(4002));
            } else {
                this.a(d2, ac2);
            }
        }
    }

    @Override
    protected /* synthetic */ IInterface d(IBinder iBinder) {
        return this.af(iBinder);
    }

    private static class a
    extends com.google.android.gms.wearable.internal.a {
        private final a.d<DataApi.DataItemResult> BO;
        private final List<FutureTask<Boolean>> BP;

        a(a.d<DataApi.DataItemResult> d2, List<FutureTask<Boolean>> list) {
            this.BO = d2;
            this.BP = list;
        }

        @Override
        public void a(am am2) {
            this.BO.a(new f.a(new Status(am2.statusCode), am2.Bp));
            if (am2.statusCode != 0) {
                for (FutureTask<Boolean> futureTask : this.BP) {
                    futureTask.cancel(true);
                }
            }
        }
    }
}

