/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import com.google.android.gms.internal.bm;
import com.google.android.gms.internal.bn;
import com.google.android.gms.internal.bt;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap AJ;

    public static DataMapItem fromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            throw new IllegalStateException("provided dataItem is null");
        }
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem source) {
        this.mUri = source.getUri();
        this.AJ = this.a((DataItem)source.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.AJ;
    }

    private DataMap a(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n2 = dataItem.getAssets().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataItemAsset dataItemAsset = dataItem.getAssets().get(Integer.toString(i2));
                if (dataItemAsset == null) {
                    throw new IllegalStateException("Cannot find DataItemAsset referenced in data at " + i2 + " for " + dataItem);
                }
                Asset asset = Asset.createFromRef(dataItemAsset.getId());
                arrayList.add(asset);
            }
            bm.a a2 = new bm.a(bn.i(dataItem.getData()), arrayList);
            return bm.a(a2);
        }
        catch (bt bt2) {
            throw new IllegalStateException("Unable to parse. Not a DataItem.");
        }
    }
}

