/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.bm;
import com.google.android.gms.internal.bn;
import com.google.android.gms.internal.bt;
import com.google.android.gms.internal.bu;
import com.google.android.gms.wearable.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class DataMap {
    public static final String TAG = "DataMap";
    private final HashMap<String, Object> AI = new HashMap();

    public static DataMap fromBundle(Bundle bundle) {
        bundle.setClassLoader(Asset.class.getClassLoader());
        DataMap dataMap = new DataMap();
        for (String string2 : bundle.keySet()) {
            DataMap.a(dataMap, string2, bundle.get(string2));
        }
        return dataMap;
    }

    public static DataMap fromByteArray(byte[] bytes) {
        try {
            return bm.a(new bm.a(bn.i(bytes), new ArrayList<Asset>()));
        }
        catch (bt bt2) {
            throw new IllegalArgumentException("Unable to convert data", bt2);
        }
    }

    public static ArrayList<DataMap> arrayListFromBundleArrayList(ArrayList<Bundle> bundleArrayList) {
        ArrayList<DataMap> arrayList = new ArrayList<DataMap>();
        for (Bundle bundle : bundleArrayList) {
            arrayList.add(DataMap.fromBundle(bundle));
        }
        return arrayList;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        for (String string2 : this.AI.keySet()) {
            DataMap.a(bundle, string2, this.AI.get(string2));
        }
        return bundle;
    }

    public byte[] toByteArray() {
        return bu.d(bm.a((DataMap)this).BU);
    }

    public int size() {
        return this.AI.size();
    }

    public boolean isEmpty() {
        return this.AI.isEmpty();
    }

    public void clear() {
        this.AI.clear();
    }

    public boolean containsKey(String key) {
        return this.AI.containsKey(key);
    }

    public <T> T get(String key) {
        return (T)this.AI.get(key);
    }

    public Object remove(String key) {
        return this.AI.remove(key);
    }

    public void putAll(DataMap dataMap) {
        for (String string2 : dataMap.keySet()) {
            this.AI.put(string2, dataMap.get(string2));
        }
    }

    public Set<String> keySet() {
        return this.AI.keySet();
    }

    public void putBoolean(String key, boolean value) {
        this.AI.put(key, value);
    }

    public void putByte(String key, byte value) {
        this.AI.put(key, value);
    }

    public void putInt(String key, int value) {
        this.AI.put(key, value);
    }

    public void putLong(String key, long value) {
        this.AI.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.AI.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.AI.put(key, value);
    }

    public void putString(String key, String value) {
        this.AI.put(key, value);
    }

    public void putAsset(String key, Asset value) {
        this.AI.put(key, value);
    }

    public void putDataMap(String key, DataMap value) {
        this.AI.put(key, value);
    }

    public void putDataMapArrayList(String key, ArrayList<DataMap> value) {
        this.AI.put(key, value);
    }

    public void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.AI.put(key, value);
    }

    public void putStringArrayList(String key, ArrayList<String> value) {
        this.AI.put(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.AI.put(key, value);
    }

    public void putLongArray(String key, long[] value) {
        this.AI.put(key, value);
    }

    public void putFloatArray(String key, float[] value) {
        this.AI.put(key, value);
    }

    public void putStringArray(String key, String[] value) {
        this.AI.put(key, value);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Boolean", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Byte)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Byte", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Integer)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Integer", classCastException);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Long)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "long", classCastException);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return ((Float)object).floatValue();
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Float", Float.valueOf(defaultValue), classCastException);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object object = this.AI.get(key);
        if (object == null) {
            return defaultValue;
        }
        try {
            return (Double)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Double", defaultValue, classCastException);
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        String string2 = this.getString(key);
        return string2 == null ? defaultValue : string2;
    }

    public String getString(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "String", classCastException);
            return null;
        }
    }

    public Asset getAsset(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (Asset)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "Asset", classCastException);
            return null;
        }
    }

    public DataMap getDataMap(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (DataMap)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, TAG, classCastException);
            return null;
        }
    }

    public ArrayList<Integer> getIntegerArrayList(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public ArrayList<String> getStringArrayList(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    public ArrayList<DataMap> getDataMapArrayList(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "ArrayList<DataMap>", classCastException);
            return null;
        }
    }

    public byte[] getByteArray(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "byte[]", classCastException);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (long[])object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "long[]", classCastException);
            return null;
        }
    }

    public float[] getFloatArray(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (float[])object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "float[]", classCastException);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        Object object = this.AI.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (String[])object;
        }
        catch (ClassCastException classCastException) {
            this.a(key, object, "String[]", classCastException);
            return null;
        }
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof DataMap)) {
            return false;
        }
        return DataMap.a(this, (DataMap)o2);
    }

    public int hashCode() {
        return 29 * this.AI.hashCode();
    }

    public String toString() {
        return this.AI.toString();
    }

    private void a(String string2, Object object, String string3, ClassCastException classCastException) {
        this.a(string2, object, string3, "<null>", classCastException);
    }

    private void a(String string2, Object object, String string3, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string2);
        stringBuilder.append(" expected ");
        stringBuilder.append(string3);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w((String)TAG, (String)stringBuilder.toString());
        Log.w((String)TAG, (String)"Attempt to cast generated internal exception:", (Throwable)classCastException);
    }

    private static boolean a(DataMap dataMap, DataMap dataMap2) {
        if (dataMap.size() != dataMap2.size()) {
            return false;
        }
        for (String string2 : dataMap.keySet()) {
            Object t2 = dataMap.get(string2);
            Object t3 = dataMap2.get(string2);
            if (t2 instanceof Asset) {
                if (!(t3 instanceof Asset)) {
                    return false;
                }
                if (DataMap.a((Asset)t2, (Asset)t3)) continue;
                return false;
            }
            if (t2 instanceof String[]) {
                if (!(t3 instanceof String[])) {
                    return false;
                }
                if (Arrays.equals((String[])t2, (String[])t3)) continue;
                return false;
            }
            if (t2 instanceof long[]) {
                if (!(t3 instanceof long[])) {
                    return false;
                }
                if (Arrays.equals((long[])t2, (long[])t3)) continue;
                return false;
            }
            if (t2 instanceof float[]) {
                if (!(t3 instanceof float[])) {
                    return false;
                }
                if (Arrays.equals((float[])t2, (float[])t3)) continue;
                return false;
            }
            if (t2 instanceof byte[]) {
                if (!(t3 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])t2, (byte[])t3)) continue;
                return false;
            }
            if (t2 == null || t3 == null) {
                return t2 == t3;
            }
            if (t2.equals(t3)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(Asset asset, Asset asset2) {
        if (asset == null || asset2 == null) {
            return asset == asset2;
        }
        if (!TextUtils.isEmpty((CharSequence)asset.getDigest())) {
            return asset.getDigest().equals(asset2.getDigest());
        }
        return Arrays.equals(asset.getData(), asset2.getData());
    }

    private static void a(DataMap dataMap, String string2, Object object) {
        if (object instanceof String) {
            dataMap.putString(string2, (String)object);
        } else if (object instanceof Integer) {
            dataMap.putInt(string2, (Integer)object);
        } else if (object instanceof Long) {
            dataMap.putLong(string2, (Long)object);
        } else if (object instanceof Double) {
            dataMap.putDouble(string2, (Double)object);
        } else if (object instanceof Float) {
            dataMap.putFloat(string2, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            dataMap.putBoolean(string2, (Boolean)object);
        } else if (object instanceof Byte) {
            dataMap.putByte(string2, (Byte)object);
        } else if (object instanceof byte[]) {
            dataMap.putByteArray(string2, (byte[])object);
        } else if (object instanceof String[]) {
            dataMap.putStringArray(string2, (String[])object);
        } else if (object instanceof long[]) {
            dataMap.putLongArray(string2, (long[])object);
        } else if (object instanceof float[]) {
            dataMap.putFloatArray(string2, (float[])object);
        } else if (object instanceof Asset) {
            dataMap.putAsset(string2, (Asset)object);
        } else if (object instanceof Bundle) {
            dataMap.putDataMap(string2, DataMap.fromBundle((Bundle)object));
        } else if (object instanceof ArrayList) {
            switch (DataMap.a((ArrayList)object)) {
                case 0: {
                    dataMap.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 1: {
                    dataMap.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 3: {
                    dataMap.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 2: {
                    dataMap.putIntegerArrayList(string2, (ArrayList)object);
                    break;
                }
                case 5: {
                    dataMap.putDataMapArrayList(string2, DataMap.arrayListFromBundleArrayList((ArrayList)object));
                }
            }
        }
    }

    private static void a(Bundle bundle, String string2, Object object) {
        if (object instanceof String) {
            bundle.putString(string2, (String)object);
        } else if (object instanceof Integer) {
            bundle.putInt(string2, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            bundle.putLong(string2, ((Long)object).longValue());
        } else if (object instanceof Double) {
            bundle.putDouble(string2, ((Double)object).doubleValue());
        } else if (object instanceof Float) {
            bundle.putFloat(string2, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            bundle.putBoolean(string2, ((Boolean)object).booleanValue());
        } else if (object instanceof Byte) {
            bundle.putByte(string2, ((Byte)object).byteValue());
        } else if (object instanceof byte[]) {
            bundle.putByteArray(string2, (byte[])object);
        } else if (object instanceof String[]) {
            bundle.putStringArray(string2, (String[])object);
        } else if (object instanceof long[]) {
            bundle.putLongArray(string2, (long[])object);
        } else if (object instanceof float[]) {
            bundle.putFloatArray(string2, (float[])object);
        } else if (object instanceof Asset) {
            bundle.putParcelable(string2, (Parcelable)((Asset)object));
        } else if (object instanceof DataMap) {
            bundle.putParcelable(string2, (Parcelable)((DataMap)object).toBundle());
        } else if (object instanceof ArrayList) {
            switch (DataMap.a((ArrayList)object)) {
                case 0: {
                    bundle.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 1: {
                    bundle.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 3: {
                    bundle.putStringArrayList(string2, (ArrayList)object);
                    break;
                }
                case 2: {
                    bundle.putIntegerArrayList(string2, (ArrayList)object);
                    break;
                }
                case 4: {
                    ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                    for (DataMap dataMap : (ArrayList)object) {
                        arrayList.add(dataMap.toBundle());
                    }
                    bundle.putParcelableArrayList(string2, arrayList);
                }
            }
        }
    }

    private static int a(ArrayList<?> arrayList) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        for (Object obj : arrayList) {
            if (obj == null) continue;
            if (obj instanceof Integer) {
                return 2;
            }
            if (obj instanceof String) {
                return 3;
            }
            if (obj instanceof DataMap) {
                return 4;
            }
            if (!(obj instanceof Bundle)) continue;
            return 5;
        }
        return 1;
    }
}

