/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.bl;
import com.google.android.gms.internal.bt;
import com.google.android.gms.internal.bu;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.cd;
import com.google.android.gms.tagmanager.cq;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cp
implements o.f {
    private final Context mContext;
    private final String wl;
    private final ExecutorService yO;
    private bg<bl.a> yH;

    cp(Context context, String string2) {
        this.mContext = context;
        this.wl = string2;
        this.yO = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<bl.a> bg2) {
        this.yH = bg2;
    }

    @Override
    public void du() {
        this.yO.execute(new Runnable(){

            @Override
            public void run() {
                cp.this.ej();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ej() {
        if (this.yH == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.yH.dt();
        bh.o("Start loading resource from disk ...");
        if ((cd.eb().ec() == cd.a.yw || cd.eb().ec() == cd.a.yx) && this.wl.equals(cd.eb().getContainerId())) {
            this.yH.a(bg.a.ya);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.ek());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.ac("resource not on disk");
            this.yH.a(bg.a.ya);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cq.b(fileInputStream, byteArrayOutputStream);
            this.yH.h(bl.a.g(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            bh.p("error reading resource from disk");
            this.yH.a(bg.a.yb);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.p("error closing stream for reading resource from disk");
            }
        }
        bh.o("Load resource from disk finished.");
    }

    @Override
    public void b(final bl.a a2) {
        this.yO.execute(new Runnable(){

            @Override
            public void run() {
                cp.this.c(a2);
            }
        });
    }

    @Override
    public cq.c Z(int n2) {
        bh.o("Atttempting to load container from resource ID " + n2);
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cq.b(inputStream, byteArrayOutputStream);
            cq.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                return c2;
            }
            return this.f(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.p("Error reading default container resource with ID " + n2);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.p("No default container resource found.");
            return null;
        }
    }

    private cq.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return ba.ak(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.ac("Tried to convert binary resource to string for JSON parsing; not UTF-8 format");
            return null;
        }
        catch (JSONException jSONException) {
            bh.p("Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cq.c f(byte[] byArray) {
        try {
            return cq.b(c.f.a(byArray));
        }
        catch (bt bt2) {
            bh.p("Resource doesn't contain a binary container");
            return null;
        }
        catch (cq.g g2) {
            bh.p("Resource doesn't contain a binary container");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.yO.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(bl.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.ek();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.m("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(bu.d(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.p("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.p("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File ek() {
        String string2 = "resource_" + this.wl;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string2);
    }
}

