/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.y;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBoundsCreator;
import com.google.android.gms.maps.model.d;

public final class LatLngBounds
implements SafeParcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int mA;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        aa.a(southwest, (Object)"null southwest");
        aa.a(northeast, (Object)"null northeast");
        aa.b(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.mA = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int bt() {
        return this.mA;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.cU()) {
            d.a(this, out, flags);
        } else {
            LatLngBoundsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    public LatLng getCenter() {
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.southwest.longitude;
        double d4 = this.northeast.longitude;
        double d5 = d3 <= d4 ? (d4 + d3) / 2.0 : (d4 + 360.0 + d3) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return y.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return y.e(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double vq = Double.POSITIVE_INFINITY;
        private double vr = Double.NEGATIVE_INFINITY;
        private double vs = Double.NaN;
        private double vt = Double.NaN;

        public Builder include(LatLng point) {
            this.vq = Math.min(this.vq, point.latitude);
            this.vr = Math.max(this.vr, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.vs)) {
                this.vs = d2;
                this.vt = d2;
            } else if (!this.b(d2)) {
                if (LatLngBounds.b(this.vs, d2) < LatLngBounds.c(this.vt, d2)) {
                    this.vs = d2;
                } else {
                    this.vt = d2;
                }
            }
            return this;
        }

        private boolean b(double d2) {
            if (this.vs <= this.vt) {
                return this.vs <= d2 && d2 <= this.vt;
            }
            return this.vs <= d2 || d2 <= this.vt;
        }

        public LatLngBounds build() {
            aa.a(!Double.isNaN(this.vs), (Object)"no included points");
            return new LatLngBounds(new LatLng(this.vq, this.vs), new LatLng(this.vr, this.vt));
        }
    }
}

