/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.aa;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int mA;
    private BitmapDescriptor vg;
    private LatLng vh;
    private float vi;
    private float vj;
    private LatLngBounds vk;
    private float uW;
    private float vd;
    private boolean ve = true;
    private float vl = 0.0f;
    private float vm = 0.5f;
    private float vn = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.mA = versionCode;
        this.vg = new BitmapDescriptor(b.a.k(wrappedImage));
        this.vh = location;
        this.vi = width;
        this.vj = height;
        this.vk = bounds;
        this.uW = bearing;
        this.vd = zIndex;
        this.ve = visible;
        this.vl = transparency;
        this.vm = anchorU;
        this.vn = anchorV;
    }

    public GroundOverlayOptions() {
        this.mA = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.cU()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder cW() {
        return this.vg.cw().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.vg = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.vm = u2;
        this.vn = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        aa.a(this.vk == null, (Object)"Position has already been set using positionFromBounds");
        aa.b(location != null, "Location must be specified");
        aa.b(width >= 0.0f, "Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        aa.a(this.vk == null, (Object)"Position has already been set using positionFromBounds");
        aa.b(location != null, "Location must be specified");
        aa.b(width >= 0.0f, "Width must be non-negative");
        aa.b(height >= 0.0f, "Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.vh = latLng;
        this.vi = f2;
        this.vj = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        aa.a(this.vh == null, "Position has already been set using position: %s", this.vh);
        this.vk = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.uW = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.vd = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.ve = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        aa.b(transparency >= 0.0f && transparency <= 1.0f, "Transparency must be in the range [0..1]");
        this.vl = transparency;
        return this;
    }

    int bt() {
        return this.mA;
    }

    public BitmapDescriptor getImage() {
        return this.vg;
    }

    public LatLng getLocation() {
        return this.vh;
    }

    public float getWidth() {
        return this.vi;
    }

    public float getHeight() {
        return this.vj;
    }

    public LatLngBounds getBounds() {
        return this.vk;
    }

    public float getBearing() {
        return this.uW;
    }

    public float getZIndex() {
        return this.vd;
    }

    public float getTransparency() {
        return this.vl;
    }

    public float getAnchorU() {
        return this.vm;
    }

    public float getAnchorV() {
        return this.vn;
    }

    public boolean isVisible() {
        return this.ve;
    }
}

