/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int mA;
    private Boolean tX;
    private Boolean tY;
    private int tZ = -1;
    private CameraPosition ua;
    private Boolean ub;
    private Boolean uc;
    private Boolean ud;
    private Boolean ue;
    private Boolean uf;
    private Boolean ug;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.mA = versionCode;
        this.tX = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.tY = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.tZ = mapType;
        this.ua = camera;
        this.ub = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.uc = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.ud = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.ue = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.uf = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.ug = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.cU()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int bt() {
        return this.mA;
    }

    byte cz() {
        return com.google.android.gms.maps.internal.a.b(this.tX);
    }

    byte cA() {
        return com.google.android.gms.maps.internal.a.b(this.tY);
    }

    byte cB() {
        return com.google.android.gms.maps.internal.a.b(this.ub);
    }

    byte cC() {
        return com.google.android.gms.maps.internal.a.b(this.uc);
    }

    byte cD() {
        return com.google.android.gms.maps.internal.a.b(this.ud);
    }

    byte cE() {
        return com.google.android.gms.maps.internal.a.b(this.ue);
    }

    byte cF() {
        return com.google.android.gms.maps.internal.a.b(this.uf);
    }

    byte cG() {
        return com.google.android.gms.maps.internal.a.b(this.ug);
    }

    public GoogleMapOptions() {
        this.mA = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.tX = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.tY = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.tZ = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.ua = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.ub = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.uc = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.ud = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.ue = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.uf = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.ug = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.tX;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.tY;
    }

    public int getMapType() {
        return this.tZ;
    }

    public CameraPosition getCamera() {
        return this.ua;
    }

    public Boolean getZoomControlsEnabled() {
        return this.ub;
    }

    public Boolean getCompassEnabled() {
        return this.uc;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.ud;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.ue;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.uf;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.ug;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

