/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.y;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mA;
    int mPriority;
    long pP;
    long pQ;
    boolean pR;
    long pE;
    int pS;
    float pT;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mA = 1;
        this.mPriority = 102;
        this.pP = 3600000L;
        this.pQ = 600000L;
        this.pR = false;
        this.pE = Long.MAX_VALUE;
        this.pS = Integer.MAX_VALUE;
        this.pT = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.H(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.b(millis);
        this.pP = millis;
        if (!this.pR) {
            this.pQ = (long)((double)this.pP / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.pP;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.b(millis);
        this.pR = true;
        this.pQ = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.pQ;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.pE = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.pE < 0L) {
            this.pE = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.pE = millis;
        if (this.pE < 0L) {
            this.pE = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.pE;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.pS = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.pS;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.pT = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.pT;
    }

    private static void b(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void H(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.mA = versionCode;
        this.mPriority = priority;
        this.pP = interval;
        this.pQ = fastestInterval;
        this.pR = explicitFastestInterval;
        this.pE = expireAt;
        this.pS = numUpdates;
        this.pT = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String I(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.I(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.pP + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.pQ + "ms");
        if (this.pE != Long.MAX_VALUE) {
            long l2 = this.pE - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.pS != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.pS);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return y.hashCode(this.mPriority, this.pP, this.pQ, this.pR, this.pE, this.pS, Float.valueOf(this.pT));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.pP == locationRequest.pP && this.pQ == locationRequest.pQ && this.pR == locationRequest.pR && this.pE == locationRequest.pE && this.pS == locationRequest.pS && this.pT == locationRequest.pT;
    }

    int bt() {
        return this.mA;
    }
}

