/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.aq;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String pC = null;
        private int pD = 0;
        private long pE = Long.MIN_VALUE;
        private short pF = (short)-1;
        private double pG;
        private double pH;
        private float pI;
        private int pJ = 0;
        private int pK = -1;

        public Builder setRequestId(String requestId) {
            this.pC = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.pD = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.pE = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.pF = 1;
            this.pG = latitude;
            this.pH = longitude;
            this.pI = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.pJ = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.pK = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.pC == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.pD == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.pD & 4) != 0 && this.pK < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.pE == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.pF == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.pJ < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new aq(this.pC, this.pD, 1, this.pG, this.pH, this.pI, this.pE, this.pJ, this.pK);
        }
    }
}

