/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.w;
import java.util.ArrayList;

public abstract class q<T extends IInterface>
implements Api.a,
r.b {
    private final Context mContext;
    private final Looper lM;
    final Handler mHandler;
    private T oe;
    private final ArrayList<b<?>> of = new ArrayList();
    private e og;
    private volatile int oh = 1;
    private final String[] oi;
    boolean oj = false;
    private final r ma;
    public static final String[] ok = new String[]{"service_esmobile", "service_googleme"};

    protected q(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = aa.f(context);
        this.lM = aa.a(looper, (Object)"Looper must not be null");
        this.ma = new r(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.oi = stringArray;
        this.registerConnectionCallbacks(aa.f(connectionCallbacks));
        this.registerConnectionFailedListener(aa.f(onConnectionFailedListener));
    }

    @Deprecated
    protected q(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new f(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String bM();

    protected abstract String bN();

    protected abstract T d(IBinder var1);

    private void x(int n2) {
        int n3 = this.oh;
        this.oh = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.oj = true;
        this.x(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.x(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.og != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.oe = null;
            s.n(this.mContext).b(this.bM(), this.og);
        }
        this.og = new e();
        boolean bl2 = s.n(this.mContext).a(this.bM(), this.og);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.bM()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.oh == 3;
    }

    public boolean isConnecting() {
        return this.oh == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.oj = false;
        ArrayList<b<?>> arrayList = this.of;
        synchronized (arrayList) {
            int n2 = this.of.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.of.get(i2).bR();
            }
            this.of.clear();
        }
        this.x(1);
        this.oe = null;
        if (this.og != null) {
            s.n(this.mContext).b(this.bM(), this.og);
            this.og = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.lM;
    }

    protected final void e(IBinder iBinder) {
        try {
            w w2 = w.a.g(iBinder);
            this.a(w2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(w var1, d var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new g(n2, iBinder, bundle)));
    }

    protected final void v() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle bq() {
        return null;
    }

    public final T bO() {
        this.v();
        return this.oe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.of;
        synchronized (arrayList) {
            this.of.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean bp() {
        return this.oj;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.ma.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.ma.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ma.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.ma.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ma.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ma.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.ma.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ma.unregisterConnectionFailedListener(listener);
    }

    public static final class d
    extends v.a {
        private q oo;

        public d(q q2) {
            this.oo = q2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            aa.a("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.oo);
            this.oo.a(n2, iBinder, bundle);
            this.oo = null;
        }
    }

    protected final class g
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle oq;
        public final IBinder or;

        public g(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.or = iBinder;
            this.oq = bundle;
        }

        protected void a(Boolean bl2) {
            if (bl2 == null) {
                q.this.x(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.or.getInterfaceDescriptor();
                        if (q.this.bN().equals(string2)) {
                            q.this.oe = q.this.d(this.or);
                            if (q.this.oe != null) {
                                q.this.x(3);
                                q.this.ma.x();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    s.n(q.this.mContext).b(q.this.bM(), q.this.og);
                    q.this.og = null;
                    q.this.x(1);
                    q.this.oe = null;
                    q.this.ma.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    q.this.x(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.oq != null) {
                        pendingIntent = (PendingIntent)this.oq.getParcelable("pendingIntent");
                    }
                    if (q.this.og != null) {
                        s.n(q.this.mContext).b(q.this.bM(), q.this.og);
                        q.this.og = null;
                    }
                    q.this.x(1);
                    q.this.oe = null;
                    q.this.ma.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void bP() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.a((Boolean)object);
        }
    }

    public static final class f
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener op;

        public f(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.op = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.op.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof f) {
                return this.op.equals(((f)other).op);
            }
            return this.op.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks on;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.on = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.on.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.on.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.on.equals(((c)other).on);
            }
            return this.on.equals(other);
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean om;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.om = false;
        }

        protected abstract void d(TListener var1);

        protected abstract void bP();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bQ() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.om) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.d(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.bP();
                    throw runtimeException;
                }
            } else {
                this.bP();
            }
            b2 = this;
            synchronized (b2) {
                this.om = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bR();
            ArrayList arrayList = q.this.of;
            synchronized (arrayList) {
                q.this.of.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bR() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !q.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.bP();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                q.this.ma.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                q.this.x(1);
                q.this.oe = null;
                q.this.ma.y((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !q.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.bP();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.bQ();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            q.this.e(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            q.this.mHandler.sendMessage(q.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

