/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.ah;

public final class j
extends Drawable
implements Drawable.Callback {
    private int nB = 0;
    private long nC;
    private int nD;
    private int nE;
    private int nF = 255;
    private int nG;
    private int nH = 0;
    private boolean nt = true;
    private boolean nI;
    private b nJ;
    private Drawable nK;
    private Drawable nL;
    private boolean nM;
    private boolean nN;
    private boolean nO;
    private int nP;

    public j(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = a.nQ;
        }
        this.nK = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.nJ.nT |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = a.nQ;
        }
        this.nL = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.nJ.nT |= drawable3.getChangingConfigurations();
    }

    j(b b2) {
        this.nJ = new b(b2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (ah.bX() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (ah.bX() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (ah.bX() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.nJ.nS | this.nJ.nT;
    }

    public void setAlpha(int alpha) {
        if (this.nH == this.nF) {
            this.nH = alpha;
        }
        this.nF = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf2) {
        this.nK.setColorFilter(cf2);
        this.nL.setColorFilter(cf2);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.nK.getIntrinsicWidth(), this.nL.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.nK.getIntrinsicHeight(), this.nL.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.nK.setBounds(bounds);
        this.nL.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.nJ.nS = this.getChangingConfigurations();
            return this.nJ;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.nO) {
            this.nP = Drawable.resolveOpacity((int)this.nK.getOpacity(), (int)this.nL.getOpacity());
            this.nO = true;
        }
        return this.nP;
    }

    public boolean canConstantState() {
        if (!this.nM) {
            this.nN = this.nK.getConstantState() != null && this.nL.getConstantState() != null;
            this.nM = true;
        }
        return this.nN;
    }

    public Drawable mutate() {
        if (!this.nI && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.nK.mutate();
            this.nL.mutate();
            this.nI = true;
        }
        return this;
    }

    public Drawable bF() {
        return this.nL;
    }

    public void startTransition(int durationMillis) {
        this.nD = 0;
        this.nE = this.nF;
        this.nH = 0;
        this.nG = durationMillis;
        this.nB = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl2 = true;
        switch (this.nB) {
            case 1: {
                this.nC = SystemClock.uptimeMillis();
                bl2 = false;
                this.nB = 2;
                break;
            }
            case 2: {
                if (this.nC < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.nC) / (float)this.nG;
                boolean bl3 = bl2 = f2 >= 1.0f;
                if (bl2) {
                    this.nB = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.nH = (int)((float)this.nD + (float)(this.nE - this.nD) * f2);
            }
        }
        int n2 = this.nH;
        boolean bl4 = this.nt;
        Drawable drawable2 = this.nK;
        Drawable drawable3 = this.nL;
        if (bl2) {
            if (!bl4 || n2 == 0) {
                drawable2.draw(canvas);
            }
            if (n2 == this.nF) {
                drawable3.setAlpha(this.nF);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl4) {
            drawable2.setAlpha(this.nF - n2);
        }
        drawable2.draw(canvas);
        if (bl4) {
            drawable2.setAlpha(this.nF);
        }
        if (n2 > 0) {
            drawable3.setAlpha(n2);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.nF);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.j$a
    extends Drawable {
        private static final com.google.android.gms.internal.j$a nQ = new com.google.android.gms.internal.j$a();
        private static final a nR = new a();

        private com.google.android.gms.internal.j$a() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf2) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return nR;
        }

        private static final class a
        extends Drawable.ConstantState {
            private a() {
            }

            public Drawable newDrawable() {
                return nQ;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class b
    extends Drawable.ConstantState {
        int nS;
        int nT;

        b(b b2) {
            if (b2 != null) {
                this.nS = b2.nS;
                this.nT = b2.nT;
            }
        }

        public Drawable newDrawable() {
            return new j(this);
        }

        public int getChangingConfigurations() {
            return this.nS;
        }
    }
}

