/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.y;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int mA;
    private final Uri ny;
    private final int nz;
    private final int nA;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.mA = versionCode;
        this.ny = url;
        this.nz = width;
        this.nA = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    int bt() {
        return this.mA;
    }

    public Uri getUrl() {
        return this.ny;
    }

    public int getWidth() {
        return this.nz;
    }

    public int getHeight() {
        return this.nA;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.nz, this.nA, this.ny.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return y.equal(this.ny, webImage.ny) && this.nz == webImage.nz && this.nA == webImage.nA;
    }

    public int hashCode() {
        return y.hashCode(this.ny, this.nz, this.nA);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

