/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.ad;
import com.google.android.gms.internal.ah;
import com.google.android.gms.internal.m;
import com.google.android.gms.internal.n;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object nb = new Object();
    private static HashSet<Uri> nc = new HashSet();
    private static ImageManager nd;
    private static ImageManager ne;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService nf;
    private final b ng;
    private final m nh;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> ni;
    private final Map<Uri, ImageReceiver> nj;
    private final Map<Uri, Long> nk;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (ne == null) {
                ne = new ImageManager(context, true);
            }
            return ne;
        }
        if (nd == null) {
            nd = new ImageManager(context, false);
        }
        return nd;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.nf = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.ng = new b(this.mContext);
            if (ah.bZ()) {
                this.bB();
            }
        } else {
            this.ng = null;
        }
        this.nh = new m();
        this.ni = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.nj = new HashMap<Uri, ImageReceiver>();
        this.nk = new HashMap<Uri, Long>();
    }

    private void bB() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.ng));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        a.b b2 = new a.b(imageView, uri);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, int resId) {
        a.b b2 = new a.b(imageView, resId);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        a.b b2 = new a.b(imageView, uri);
        b2.u(defaultResId);
        this.a(b2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        a.c c2 = new a.c(listener, uri);
        this.a(c2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        a.c c2 = new a.c(listener, uri);
        c2.u(defaultResId);
        this.a(c2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        n.z("ImageManager.loadImage() must be called in the main thread");
        d d2 = new d(a2);
        d2.run();
    }

    private Bitmap a(a.a a2) {
        if (this.ng == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.ng.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class b
    extends ad<a.a, Bitmap> {
        public b(Context context) {
            super(b.m(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int m(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && ah.bX() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b ng;

        public e(b b2) {
            this.ng = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.ng.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.ng.evictAll();
            } else if (level >= 20) {
                this.ng.trimToSize(this.ng.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch lw;
        private boolean np;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.np = bl2;
            this.lw = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            n.z("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.ng != null) {
                if (this.np) {
                    ImageManager.this.ng.evictAll();
                    System.gc();
                    this.np = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.ng.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.nj.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.lw.countDown();
            Object object = nb;
            synchronized (object) {
                nc.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            ArrayList arrayList = imageReceiver.nl;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.nk.put(this.mUri, SystemClock.elapsedRealtime());
                    a2.a(ImageManager.this.mContext, ImageManager.this.nh, false);
                }
                if (a2 instanceof a.c) continue;
                ImageManager.this.ni.remove(a2);
            }
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor nn;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.nn = parcelFileDescriptor;
        }

        @Override
        public void run() {
            n.A("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.nn != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.nn.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.nn.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> nl;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.nl = new ArrayList();
        }

        public void b(com.google.android.gms.common.images.a a2) {
            n.z("ImageReceiver.addImageRequest() must be called in the main thread");
            this.nl.add(a2);
        }

        public void c(com.google.android.gms.common.images.a a2) {
            n.z("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.nl.remove(a2);
        }

        public void bE() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.nf.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a no;

        public d(com.google.android.gms.common.images.a a2) {
            this.no = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            n.z("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.ni.get(this.no));
            if (imageReceiver != null) {
                ImageManager.this.ni.remove(this.no);
                imageReceiver.c(this.no);
            }
            a.a a2 = this.no.nq;
            if (a2.uri == null) {
                this.no.a(ImageManager.this.mContext, ImageManager.this.nh, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.no.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l2 = (Long)ImageManager.this.nk.get(a2.uri);
            if (l2 != null) {
                if (SystemClock.elapsedRealtime() - l2 < 3600000L) {
                    this.no.a(ImageManager.this.mContext, ImageManager.this.nh, true);
                    return;
                }
                ImageManager.this.nk.remove(a2.uri);
            }
            this.no.a(ImageManager.this.mContext, ImageManager.this.nh);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.nj.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.nj.put(a2.uri, imageReceiver);
            }
            imageReceiver.b(this.no);
            if (!(this.no instanceof a.c)) {
                ImageManager.this.ni.put(this.no, imageReceiver);
            }
            Object object = nb;
            synchronized (object) {
                boolean bl2 = nc.contains(a2.uri);
                if (!bl2) {
                    nc.add(a2.uri);
                    imageReceiver.bE();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

