/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.u;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class a {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class c<R extends Result>
    extends Handler {
        public c() {
            this(Looper.getMainLooper());
        }

        public c(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<R> resultCallback, R r2) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r2)));
        }

        public void a(a<R> a2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, a2), l2);
        }

        public void bi() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.b((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    a a2 = (a)msg.obj;
                    a2.bg();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void b(ResultCallback<R> resultCallback, R r2) {
            try {
                resultCallback.onResult(r2);
            }
            catch (RuntimeException runtimeException) {
                a.a(r2);
                throw runtimeException;
            }
        }
    }

    public static abstract class a<R extends Result>
    implements PendingResult<R>,
    d<R> {
        private final Object lu = new Object();
        private c<R> lv;
        private final CountDownLatch lw = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> lx = new ArrayList();
        private ResultCallback<R> ly;
        private volatile R lz;
        private volatile boolean lA;
        private boolean lB;
        private boolean lC;
        private u lD;

        a() {
        }

        public a(Looper looper) {
            this.lv = new c(looper);
        }

        public a(c<R> c2) {
            this.lv = c2;
        }

        protected abstract R a(Status var1);

        public final boolean isReady() {
            return this.lw.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R bd() {
            Object object = this.lu;
            synchronized (object) {
                aa.a(!this.lA, (Object)"Result has already been consumed.");
                aa.a(this.isReady(), (Object)"Result is not ready.");
                R r2 = this.lz;
                this.be();
                return r2;
            }
        }

        @Override
        public final R await() {
            aa.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
            aa.a(!this.lA, (Object)"Result has already been consumed");
            try {
                this.lw.await();
            }
            catch (InterruptedException interruptedException) {
                this.bf();
            }
            aa.a(this.isReady(), (Object)"Result is not ready.");
            return this.bd();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            aa.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
            aa.a(!this.lA, (Object)"Result has already been consumed.");
            try {
                boolean bl2 = this.lw.await(time, units);
                if (!bl2) {
                    this.bg();
                }
            }
            catch (InterruptedException interruptedException) {
                this.bf();
            }
            aa.a(this.isReady(), (Object)"Result is not ready.");
            return this.bd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            aa.a(!this.lA, (Object)"Result has already been consumed.");
            Object object = this.lu;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.lv.a(callback, this.bd());
                } else {
                    this.ly = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            aa.a(!this.lA, (Object)"Result has already been consumed.");
            Object object = this.lu;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.lv.a(callback, this.bd());
                } else {
                    this.ly = callback;
                    this.lv.a(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            aa.a(!this.lA, (Object)"Result has already been consumed.");
            Object object = this.lu;
            synchronized (object) {
                if (this.isReady()) {
                    a2.c(this.lz.getStatus());
                } else {
                    this.lx.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.lu;
            synchronized (object) {
                if (this.lB || this.lA) {
                    return;
                }
                if (this.lD != null) {
                    try {
                        this.lD.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                a.a(this.lz);
                this.ly = null;
                this.lB = true;
                this.c(this.a(Status.mz));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.lu;
            synchronized (object) {
                return this.lB;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void b(R r2) {
            Object object = this.lu;
            synchronized (object) {
                if (this.lC || this.lB) {
                    a.a(r2);
                    return;
                }
                aa.a(!this.isReady(), (Object)"Results have already been set");
                aa.a(!this.lA, (Object)"Result has already been consumed");
                this.c(r2);
            }
        }

        protected void be() {
            this.lA = true;
            this.lz = null;
            this.ly = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bf() {
            Object object = this.lu;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.mw));
                    this.lC = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bg() {
            Object object = this.lu;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.my));
                    this.lC = true;
                }
            }
        }

        private void c(R r2) {
            this.lz = r2;
            this.lD = null;
            this.lw.countDown();
            Status status = this.lz.getStatus();
            if (this.ly != null) {
                this.lv.bi();
                if (!this.lB) {
                    this.lv.a(this.ly, this.bd());
                }
            }
            for (PendingResult.a a2 : this.lx) {
                a2.c(status);
            }
            this.lx.clear();
        }

        @Override
        protected void a(c<R> c2) {
            this.lv = c2;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.b((Result)object);
        }
    }

    public static abstract class b<R extends Result, A extends Api.a>
    extends a<R>
    implements b.c<A> {
        private final Api.c<A> ls;
        private b.a lE;

        protected b(Api.c<A> c2) {
            this.ls = aa.f(c2);
        }

        @Override
        public final Api.c<A> bc() {
            return this.ls;
        }

        @Override
        public final void a(A a2) throws DeadObjectException {
            this.a((A)((Object)new c(a2.getLooper())));
            try {
                this.b(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void b(Status status) {
            aa.b(!status.isSuccess(), "Failed result must not be success");
            this.b((A)this.a(status));
        }

        @Override
        public void a(b.a a2) {
            this.lE = a2;
        }

        @Override
        public int bh() {
            return 0;
        }

        @Override
        protected abstract void b(A var1) throws RemoteException;

        @Override
        protected void be() {
            super.be();
            if (this.lE != null) {
                this.lE.b(this);
                this.lE = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.b(status);
        }
    }

    public static interface d<R> {
        public void a(R var1);
    }
}

