/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.y;

public final class Status
implements Result,
SafeParcelable {
    public static final Status mv = new Status(0);
    public static final Status mw = new Status(14);
    public static final Status mx = new Status(8);
    public static final Status my = new Status(15);
    public static final Status mz = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int mA;
    private final int kY;
    private final String mB;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.mA = versionCode;
        this.kY = statusCode;
        this.mB = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent bs() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.mB;
    }

    int bt() {
        return this.mA;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.kY <= 0;
    }

    public boolean isCanceled() {
        return this.kY == 16;
    }

    public boolean isInterrupted() {
        return this.kY == 14;
    }

    public int getStatusCode() {
        return this.kY;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return y.hashCode(this.mA, this.kY, this.mB, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.mA == status.mA && this.kY == status.kY && y.equal(this.mB, status.mB) && y.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String aY() {
        if (this.mB != null) {
            return this.mB;
        }
        return CommonStatusCodes.getStatusCodeString(this.kY);
    }

    public String toString() {
        return y.e(this).a("statusCode", this.aY()).a("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

