/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.api.c;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.o;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, T extends a.b<? extends Result, A>> T a(T var1);

    public <A extends Api.a, T extends a.b<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public void stopAutoManage();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String lO;
        private final Set<String> lP = new HashSet<String>();
        private int lQ;
        private View lR;
        private String lS;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> lT = new HashMap();
        private FragmentActivity lU;
        private OnConnectionFailedListener lV;
        private Looper lM;
        private final Set<ConnectionCallbacks> lW = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> lX = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.lM = context.getMainLooper();
            this.lS = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            aa.a(connectedListener, (Object)"Must provide a connected listener");
            this.lW.add(connectedListener);
            aa.a(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.lX.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            aa.a(handler, (Object)"Handler must not be null");
            this.lM = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.lW.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.lX.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.lR = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.lP.add(scope.br());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.lT.put(api, null);
            List<Scope> list = api.bb();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.lP.add(list.get(i2).br());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            aa.a(options, (Object)"Null options are not permitted for this Api");
            this.lT.put(api, options);
            List<Scope> list = api.bb();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.lP.add(list.get(i2).br());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.lO = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.lQ = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            this.lU = aa.a(fragmentActivity, (Object)"Null activity is not permitted.");
            this.lV = unresolvedConnectionFailedListener;
            return this;
        }

        public o bj() {
            return new o(this.lO, this.lP, this.lQ, this.lR, this.lS);
        }

        public GoogleApiClient build() {
            aa.b(!this.lT.isEmpty(), "must call addApi() to add at least one API");
            c c2 = null;
            if (this.lU != null) {
                c2 = this.bk();
            }
            b b2 = new b(this.mContext, this.lM, this.bj(), this.lT, c2, this.lW, this.lX);
            if (c2 != null) {
                c2.a(b2, this.lV);
            }
            return b2;
        }

        private c bk() {
            FragmentManager fragmentManager = this.lU.getSupportFragmentManager();
            List list = fragmentManager.getFragments();
            if (list != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof c) || !fragment.isAdded() || ((c)fragment).isInitialized()) continue;
                    return (c)fragment;
                }
            }
            c c2 = new c();
            fragmentManager.beginTransaction().add((Fragment)c2, null).commit();
            return c2;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

