/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.ac;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int lo;
    private View lp;
    private View.OnClickListener lq = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.lo);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        aa.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        aa.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.lo = colorScheme;
        this.l(this.getContext());
    }

    private void l(Context context) {
        if (this.lp != null) {
            this.removeView(this.lp);
        }
        try {
            this.lp = ab.b(context, this.mSize, this.lo);
        }
        catch (e.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.lp = SignInButton.a(context, this.mSize, this.lo);
        }
        this.addView(this.lp);
        this.lp.setEnabled(this.isEnabled());
        this.lp.setOnClickListener((View.OnClickListener)this);
    }

    private static Button a(Context context, int n2, int n3) {
        ac ac2 = new ac(context);
        ac2.a(context.getResources(), n2, n3);
        return ac2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.lq = listener;
        if (this.lp != null) {
            this.lp.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lp.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.lq != null && view == this.lp) {
            this.lq.onClick((View)this);
        }
    }
}

